/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.map.internal;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.samples.map.IDestination;
import org.eclipse.sapphire.samples.map.IMap;
import org.eclipse.sapphire.samples.map.IRoute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Map
extends ModelElement
implements IMap {
    private ModelElementList<IDestination> destinations;
    private ModelElementList<IRoute> routes;

    public Map(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public Map(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IDestination> getDestinations() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.destinations == null) {
                this.refresh((ModelProperty)PROP_DESTINATIONS, true);
            }
            return this.destinations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IRoute> getRoutes() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.routes == null) {
                this.refresh((ModelProperty)PROP_ROUTES, true);
            }
            return this.routes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_DESTINATIONS) {
                if (this.destinations == null) {
                    if (force) {
                        this.destinations = new ModelElementList((IModelElement)this, PROP_DESTINATIONS);
                        ListBindingImpl binding = this.resource().binding(PROP_DESTINATIONS);
                        this.destinations.init(binding);
                        this.refreshPropertyEnablement((ModelProperty)PROP_DESTINATIONS);
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_DESTINATIONS);
                    boolean notified = this.destinations.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_DESTINATIONS, enablementRefreshResult);
                    }
                }
            } else if (property == PROP_ROUTES) {
                if (this.routes == null) {
                    if (force) {
                        this.routes = new ModelElementList((IModelElement)this, PROP_ROUTES);
                        ListBindingImpl binding = this.resource().binding(PROP_ROUTES);
                        this.routes.init(binding);
                        this.refreshPropertyEnablement((ModelProperty)PROP_ROUTES);
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_ROUTES);
                    boolean notified = this.routes.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_ROUTES, enablementRefreshResult);
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_DESTINATIONS) {
            return this.getDestinations();
        }
        if (property == PROP_ROUTES) {
            return this.getRoutes();
        }
        return super.read(property);
    }
}

