/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SapphireTestCase
extends TestCase {
    private IProject project;

    protected SapphireTestCase(String name) {
        super(name);
    }

    protected final IProject project() throws Exception {
        if (this.project == null) {
            String name = String.valueOf(((Object)((Object)this)).getClass().getName()) + "." + this.getName();
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            this.project.create(null);
            this.project.open(null);
        }
        return this.project;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.project != null) {
            this.project.delete(true, null);
        }
    }

    protected final InputStream loadResourceAsStream(String name) {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(name);
        if (in == null) {
            throw new IllegalArgumentException(name);
        }
        return in;
    }

    protected final String loadResource(String name) throws Exception {
        String string;
        InputStream in = this.loadResourceAsStream(name);
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            char[] chars = new char[1024];
            StringBuilder buf = new StringBuilder();
            int i = r.read(chars);
            while (i != -1) {
                buf.append(chars, 0, i);
                i = r.read(chars);
            }
            string = buf.toString();
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        return string;
    }

    protected static final void assertEqualsIgnoreNewLineDiffs(String expected, String actual) {
        SapphireTestCase.assertEquals((String)expected.trim().replace("\r", ""), (String)actual.trim().replace("\r", ""));
    }

    protected static final void assertValidationOk(Value<?> value) {
        SapphireTestCase.assertEquals((Object)Status.Severity.OK, (Object)value.validate().severity());
    }

    protected static final void assertValidationError(Value<?> value, String expectedMessage) {
        Status st = value.validate();
        SapphireTestCase.assertEquals((Object)Status.Severity.ERROR, (Object)st.severity());
        SapphireTestCase.assertEquals((String)expectedMessage, (String)st.message());
    }

    protected static <T> List<T> list(T ... items) {
        return Arrays.asList(items);
    }

    protected static <T> Set<T> set(T ... items) {
        return new LinkedHashSet<T>(Arrays.asList(items));
    }
}

