/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.java.t0004;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.java.t0004.ITestElement;

public class TestJava0004
extends SapphireTestCase {
    private ITestElement element;

    protected TestJava0004(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("Java0004");
        suite.addTest((Test)new TestJava0004("testOptionalAnyType"));
        suite.addTest((Test)new TestJava0004("testRequiredClass1"));
        suite.addTest((Test)new TestJava0004("testRequiredClass2"));
        suite.addTest((Test)new TestJava0004("testRequiredClass3"));
        suite.addTest((Test)new TestJava0004("testRequiredClass4"));
        suite.addTest((Test)new TestJava0004("testRequiredClass5"));
        suite.addTest((Test)new TestJava0004("testRequiredClass6"));
        suite.addTest((Test)new TestJava0004("testRequiredInterface1"));
        suite.addTest((Test)new TestJava0004("testRequiredInterface2"));
        suite.addTest((Test)new TestJava0004("testRequiredInterface3"));
        suite.addTest((Test)new TestJava0004("testRequiredAnnotation1"));
        suite.addTest((Test)new TestJava0004("testRequiredEnum1"));
        suite.addTest((Test)new TestJava0004("testRequiredMixedType1"));
        suite.addTest((Test)new TestJava0004("testRequiredMixedType2"));
        return suite;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.element = this.createTestElement();
    }

    protected ITestElement createTestElement() throws Exception {
        return (ITestElement)ITestElement.TYPE.instantiate();
    }

    public void testOptionalAnyType() {
        ValueProperty property = ITestElement.PROP_OPTIONAL_ANY_TYPE;
        this.test(property, "foo.bar.FooBar");
        this.test(property, "java.util.ArrayList");
        this.test(property, "java.util.AbstractList");
        this.test(property, "java.util.List");
        this.test(property, "java.lang.Deprecated");
        this.test(property, "java.lang.annotation.ElementType");
    }

    public void testRequiredClass1() {
        ValueProperty property = ITestElement.PROP_REQUIRED_CLASS_1;
        this.test(property, "foo.bar.FooBar", "Could not resolve required class 1 \"foo.bar.FooBar\".");
        this.test(property, "java.util.ArrayList");
        this.test(property, "java.util.AbstractList");
        this.test(property, "java.util.List", "Type java.util.List is an interface, which is not allowed for required class 1.");
        this.test(property, "java.lang.Deprecated", "Type java.lang.Deprecated is an annotation, which is not allowed for required class 1.");
        this.test(property, "java.lang.annotation.ElementType", "Type java.lang.annotation.ElementType is an enum, which is not allowed for required class 1.");
    }

    public void testRequiredClass2() {
        ValueProperty property = ITestElement.PROP_REQUIRED_CLASS_2;
        this.test(property, "foo.bar.FooBar", "Could not resolve required class 2 \"foo.bar.FooBar\".");
        this.test(property, "java.util.ArrayList");
        this.test(property, "java.util.AbstractList");
        this.test(property, "java.util.HashMap", "Class java.util.HashMap does not implement or extend java.util.List.");
        this.test(property, "java.util.List", "Type java.util.List is an interface, which is not allowed for required class 2.");
        this.test(property, "java.lang.Deprecated", "Type java.lang.Deprecated is an annotation, which is not allowed for required class 2.");
        this.test(property, "java.lang.annotation.ElementType", "Type java.lang.annotation.ElementType is an enum, which is not allowed for required class 2.");
    }

    public void testRequiredClass3() {
        ValueProperty property = ITestElement.PROP_REQUIRED_CLASS_3;
        this.test(property, "foo.bar.FooBar", "Could not resolve required class 3 \"foo.bar.FooBar\".");
        this.test(property, "java.util.ArrayList");
        this.test(property, "java.util.AbstractList");
        this.test(property, "java.util.HashMap", "Class java.util.HashMap does not implement or extend java.util.AbstractList.");
        this.test(property, "java.util.List", "Type java.util.List is an interface, which is not allowed for required class 3.");
        this.test(property, "java.lang.Deprecated", "Type java.lang.Deprecated is an annotation, which is not allowed for required class 3.");
        this.test(property, "java.lang.annotation.ElementType", "Type java.lang.annotation.ElementType is an enum, which is not allowed for required class 3.");
    }

    public void testRequiredClass4() {
        ValueProperty property = ITestElement.PROP_REQUIRED_CLASS_4;
        this.test(property, "foo.bar.FooBar", "Could not resolve required class 4 \"foo.bar.FooBar\".");
        this.test(property, "java.util.ArrayList");
        this.test(property, "java.util.AbstractList", "Class java.util.AbstractList does not implement or extend java.lang.Cloneable.");
        this.test(property, "java.util.HashMap", "Class java.util.HashMap does not implement or extend java.util.AbstractList.");
        this.test(property, "java.util.List", "Type java.util.List is an interface, which is not allowed for required class 4.");
        this.test(property, "java.lang.Deprecated", "Type java.lang.Deprecated is an annotation, which is not allowed for required class 4.");
        this.test(property, "java.lang.annotation.ElementType", "Type java.lang.annotation.ElementType is an enum, which is not allowed for required class 4.");
    }

    public void testRequiredClass5() {
        ValueProperty property = ITestElement.PROP_REQUIRED_CLASS_5;
        this.test(property, "foo.bar.FooBar", "Could not resolve required class 5 \"foo.bar.FooBar\".");
        this.test(property, "java.util.ArrayList");
        this.test(property, "java.util.AbstractList", "Type java.util.AbstractList is an abstract class, which is not allowed for required class 5.");
        this.test(property, "java.util.HashMap", "Class java.util.HashMap does not implement or extend java.util.AbstractList.");
        this.test(property, "java.util.List", "Type java.util.List is an interface, which is not allowed for required class 5.");
        this.test(property, "java.lang.Deprecated", "Type java.lang.Deprecated is an annotation, which is not allowed for required class 5.");
        this.test(property, "java.lang.annotation.ElementType", "Type java.lang.annotation.ElementType is an enum, which is not allowed for required class 5.");
    }

    public void testRequiredClass6() {
        ValueProperty property = ITestElement.PROP_REQUIRED_CLASS_6;
        this.test(property, "foo.bar.FooBar", "Could not resolve required class 6 \"foo.bar.FooBar\".");
        this.test(property, "java.util.ArrayList");
        this.test(property, "java.util.HashMap");
        this.test(property, "java.util.HashSet", "Class java.util.HashSet does not implement or extend one of [java.util.List, java.util.Map].");
        this.test(property, "java.util.AbstractList", "Type java.util.AbstractList is an abstract class, which is not allowed for required class 6.");
        this.test(property, "java.util.List", "Type java.util.List is an interface, which is not allowed for required class 6.");
        this.test(property, "java.lang.Deprecated", "Type java.lang.Deprecated is an annotation, which is not allowed for required class 6.");
        this.test(property, "java.lang.annotation.ElementType", "Type java.lang.annotation.ElementType is an enum, which is not allowed for required class 6.");
    }

    public void testRequiredInterface1() {
        ValueProperty property = ITestElement.PROP_REQUIRED_INTERFACE_1;
        this.test(property, "foo.bar.FooBar", "Could not resolve required interface 1 \"foo.bar.FooBar\".");
        this.test(property, "java.util.ArrayList", "Type java.util.ArrayList is a class, which is not allowed for required interface 1.");
        this.test(property, "java.util.AbstractList", "Type java.util.AbstractList is an abstract class, which is not allowed for required interface 1.");
        this.test(property, "java.util.HashMap", "Type java.util.HashMap is a class, which is not allowed for required interface 1.");
        this.test(property, "java.util.List");
        this.test(property, "java.lang.Deprecated", "Type java.lang.Deprecated is an annotation, which is not allowed for required interface 1.");
        this.test(property, "java.lang.annotation.ElementType", "Type java.lang.annotation.ElementType is an enum, which is not allowed for required interface 1.");
    }

    public void testRequiredInterface2() {
        ValueProperty property = ITestElement.PROP_REQUIRED_INTERFACE_2;
        this.test(property, "foo.bar.FooBar", "Could not resolve required interface 2 \"foo.bar.FooBar\".");
        this.test(property, "java.util.ArrayList", "Type java.util.ArrayList is a class, which is not allowed for required interface 2.");
        this.test(property, "java.util.AbstractList", "Type java.util.AbstractList is an abstract class, which is not allowed for required interface 2.");
        this.test(property, "java.util.HashMap", "Type java.util.HashMap is a class, which is not allowed for required interface 2.");
        this.test(property, "java.util.List");
        this.test(property, "java.util.Set", "Interface java.util.Set does not extend java.util.List.");
        this.test(property, "java.lang.Deprecated", "Type java.lang.Deprecated is an annotation, which is not allowed for required interface 2.");
        this.test(property, "java.lang.annotation.ElementType", "Type java.lang.annotation.ElementType is an enum, which is not allowed for required interface 2.");
    }

    public void testRequiredInterface3() {
        ValueProperty property = ITestElement.PROP_REQUIRED_INTERFACE_3;
        this.test(property, "foo.bar.FooBar", "Could not resolve required interface 3 \"foo.bar.FooBar\".");
        this.test(property, "java.util.ArrayList", "Type java.util.ArrayList is a class, which is not allowed for required interface 3.");
        this.test(property, "java.util.AbstractList", "Type java.util.AbstractList is an abstract class, which is not allowed for required interface 3.");
        this.test(property, "java.util.HashMap", "Type java.util.HashMap is a class, which is not allowed for required interface 3.");
        this.test(property, "java.util.List", "Interface java.util.List does not extend java.lang.Cloneable.");
        this.test(property, "java.util.Set", "Interface java.util.Set does not extend java.util.List.");
        this.test(property, "java.lang.Deprecated", "Type java.lang.Deprecated is an annotation, which is not allowed for required interface 3.");
        this.test(property, "java.lang.annotation.ElementType", "Type java.lang.annotation.ElementType is an enum, which is not allowed for required interface 3.");
    }

    public void testRequiredAnnotation1() {
        ValueProperty property = ITestElement.PROP_REQUIRED_ANNOTATION_1;
        this.test(property, "foo.bar.FooBar", "Could not resolve required annotation 1 \"foo.bar.FooBar\".");
        this.test(property, "java.util.ArrayList", "Type java.util.ArrayList is a class, which is not allowed for required annotation 1.");
        this.test(property, "java.util.AbstractList", "Type java.util.AbstractList is an abstract class, which is not allowed for required annotation 1.");
        this.test(property, "java.util.HashMap", "Type java.util.HashMap is a class, which is not allowed for required annotation 1.");
        this.test(property, "java.util.List", "Type java.util.List is an interface, which is not allowed for required annotation 1.");
        this.test(property, "java.util.Set", "Type java.util.Set is an interface, which is not allowed for required annotation 1.");
        this.test(property, "java.lang.Deprecated");
        this.test(property, "java.lang.annotation.ElementType", "Type java.lang.annotation.ElementType is an enum, which is not allowed for required annotation 1.");
    }

    public void testRequiredEnum1() {
        ValueProperty property = ITestElement.PROP_REQUIRED_ENUM_1;
        this.test(property, "foo.bar.FooBar", "Could not resolve required enum 1 \"foo.bar.FooBar\".");
        this.test(property, "java.util.ArrayList", "Type java.util.ArrayList is a class, which is not allowed for required enum 1.");
        this.test(property, "java.util.AbstractList", "Type java.util.AbstractList is an abstract class, which is not allowed for required enum 1.");
        this.test(property, "java.util.HashMap", "Type java.util.HashMap is a class, which is not allowed for required enum 1.");
        this.test(property, "java.util.List", "Type java.util.List is an interface, which is not allowed for required enum 1.");
        this.test(property, "java.util.Set", "Type java.util.Set is an interface, which is not allowed for required enum 1.");
        this.test(property, "java.lang.Deprecated", "Type java.lang.Deprecated is an annotation, which is not allowed for required enum 1.");
        this.test(property, "java.lang.annotation.ElementType");
    }

    public void testRequiredMixedType1() {
        ValueProperty property = ITestElement.PROP_REQUIRED_MIXED_TYPE_1;
        this.test(property, "foo.bar.FooBar", "Could not resolve required mixed type 1 \"foo.bar.FooBar\".");
        this.test(property, "java.util.ArrayList");
        this.test(property, "java.util.AbstractList", "Type java.util.AbstractList is an abstract class, which is not allowed for required mixed type 1.");
        this.test(property, "java.util.HashMap");
        this.test(property, "java.util.List");
        this.test(property, "java.util.Set");
        this.test(property, "java.lang.Deprecated", "Type java.lang.Deprecated is an annotation, which is not allowed for required mixed type 1.");
        this.test(property, "java.lang.annotation.ElementType", "Type java.lang.annotation.ElementType is an enum, which is not allowed for required mixed type 1.");
    }

    public void testRequiredMixedType2() {
        ValueProperty property = ITestElement.PROP_REQUIRED_MIXED_TYPE_2;
        this.test(property, "foo.bar.FooBar", "Could not resolve required mixed type 2 \"foo.bar.FooBar\".");
        this.test(property, "java.util.ArrayList");
        this.test(property, "java.util.AbstractList", "Type java.util.AbstractList is an abstract class, which is not allowed for required mixed type 2.");
        this.test(property, "java.util.HashMap");
        this.test(property, "java.util.List");
        this.test(property, "java.util.Set");
        this.test(property, "java.lang.Deprecated", "Type java.lang.Deprecated is an annotation, which is not allowed for required mixed type 2.");
        this.test(property, "java.lang.annotation.ElementType");
    }

    private void test(ValueProperty property, String value) {
        this.test(property, value, null);
    }

    private void test(ValueProperty property, String value, String expectedErrorMessage) {
        this.element.write(property, value);
        if (expectedErrorMessage == null) {
            TestJava0004.assertValidationOk(this.element.read(property));
        } else {
            TestJava0004.assertValidationError(this.element.read(property), expectedErrorMessage);
        }
    }
}

