/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.misc.t0002;

import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.sapphire.modeling.util.DependencySorter;
import org.eclipse.sapphire.tests.SapphireTestCase;

public final class TestMisc0002
extends SapphireTestCase {
    private TestMisc0002(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("Misc0002");
        suite.addTest((Test)new TestMisc0002("testNoItems"));
        suite.addTest((Test)new TestMisc0002("testOneItem"));
        suite.addTest((Test)new TestMisc0002("testMultipleUnrelatedItems"));
        suite.addTest((Test)new TestMisc0002("testSimpleDependency"));
        suite.addTest((Test)new TestMisc0002("testMultiLevelDependency"));
        suite.addTest((Test)new TestMisc0002("testCycleBreaking1"));
        suite.addTest((Test)new TestMisc0002("testCycleBreaking2"));
        suite.addTest((Test)new TestMisc0002("testCycleBreaking3"));
        return suite;
    }

    public void testNoItems() throws Exception {
        DependencySorter sorter = new DependencySorter();
        List sorted = sorter.sort();
        TestMisc0002.assertEquals((int)0, (int)sorted.size());
    }

    public void testOneItem() throws Exception {
        DependencySorter sorter = new DependencySorter();
        Object a = new Object();
        sorter.add((Object)"a", a);
        List sorted = sorter.sort();
        TestMisc0002.assertEquals((int)1, (int)sorted.size());
        TestMisc0002.assertTrue((boolean)sorted.contains(a));
    }

    public void testMultipleUnrelatedItems() throws Exception {
        DependencySorter sorter = new DependencySorter();
        Object a = new Object();
        sorter.add((Object)"a", a);
        Object b = new Object();
        sorter.add((Object)"b", b);
        Object c = new Object();
        sorter.add((Object)"c", c);
        List sorted = sorter.sort();
        TestMisc0002.assertEquals((int)3, (int)sorted.size());
        TestMisc0002.assertTrue((boolean)sorted.contains(a));
        TestMisc0002.assertTrue((boolean)sorted.contains(b));
        TestMisc0002.assertTrue((boolean)sorted.contains(c));
    }

    public void testSimpleDependency() throws Exception {
        DependencySorter sorter = new DependencySorter();
        Object a = new Object();
        sorter.add((Object)"a", a);
        sorter.dependency(a, (Object)"c");
        Object b = new Object();
        sorter.add((Object)"b", b);
        Object c = new Object();
        sorter.add((Object)"c", c);
        List sorted = sorter.sort();
        TestMisc0002.assertEquals((int)3, (int)sorted.size());
        TestMisc0002.assertTrue((boolean)sorted.contains(a));
        TestMisc0002.assertTrue((boolean)sorted.contains(b));
        TestMisc0002.assertTrue((boolean)sorted.contains(c));
        TestMisc0002.assertTrue((sorted.indexOf(c) < sorted.indexOf(a) ? 1 : 0) != 0);
    }

    public void testMultiLevelDependency() throws Exception {
        DependencySorter sorter = new DependencySorter();
        Object a = new Object();
        sorter.add((Object)"a", a);
        sorter.dependency(a, (Object)"b");
        Object b = new Object();
        sorter.add((Object)"b", b);
        sorter.dependency(b, (Object)"c");
        Object c = new Object();
        sorter.add((Object)"c", c);
        List sorted = sorter.sort();
        TestMisc0002.assertEquals((int)3, (int)sorted.size());
        TestMisc0002.assertTrue((boolean)sorted.contains(a));
        TestMisc0002.assertTrue((boolean)sorted.contains(b));
        TestMisc0002.assertTrue((boolean)sorted.contains(c));
        TestMisc0002.assertTrue((sorted.indexOf(c) < sorted.indexOf(b) ? 1 : 0) != 0);
        TestMisc0002.assertTrue((sorted.indexOf(b) < sorted.indexOf(a) ? 1 : 0) != 0);
    }

    public void testCycleBreaking1() throws Exception {
        DependencySorter sorter = new DependencySorter();
        Object a = new Object();
        sorter.add((Object)"a", a);
        sorter.dependency(a, (Object)"b");
        Object b = new Object();
        sorter.add((Object)"b", b);
        sorter.dependency(b, (Object)"c");
        Object c = new Object();
        sorter.add((Object)"c", c);
        sorter.dependency(c, (Object)"b");
        List sorted = sorter.sort();
        TestMisc0002.assertEquals((int)3, (int)sorted.size());
        TestMisc0002.assertTrue((boolean)sorted.contains(a));
        TestMisc0002.assertTrue((boolean)sorted.contains(b));
        TestMisc0002.assertTrue((boolean)sorted.contains(c));
    }

    public void testCycleBreaking2() throws Exception {
        DependencySorter sorter = new DependencySorter();
        Object a = new Object();
        sorter.add((Object)"a", a);
        sorter.dependency(a, (Object)"b");
        Object b = new Object();
        sorter.add((Object)"b", b);
        sorter.dependency(b, (Object)"c");
        Object c = new Object();
        sorter.add((Object)"c", c);
        sorter.dependency(c, (Object)"a");
        List sorted = sorter.sort();
        TestMisc0002.assertEquals((int)3, (int)sorted.size());
        TestMisc0002.assertTrue((boolean)sorted.contains(a));
        TestMisc0002.assertTrue((boolean)sorted.contains(b));
        TestMisc0002.assertTrue((boolean)sorted.contains(c));
    }

    public void testCycleBreaking3() throws Exception {
        DependencySorter sorter = new DependencySorter();
        Object a = new Object();
        sorter.add((Object)"a", a);
        sorter.dependency(a, (Object)"b");
        Object b = new Object();
        sorter.add((Object)"b", b);
        sorter.dependency(b, (Object)"c");
        Object c = new Object();
        sorter.add((Object)"c", c);
        sorter.dependency(c, (Object)"a");
        Object d = new Object();
        sorter.add((Object)"d", d);
        List sorted = sorter.sort();
        TestMisc0002.assertEquals((int)4, (int)sorted.size());
        TestMisc0002.assertTrue((boolean)sorted.contains(a));
        TestMisc0002.assertTrue((boolean)sorted.contains(b));
        TestMisc0002.assertTrue((boolean)sorted.contains(c));
        TestMisc0002.assertTrue((boolean)sorted.contains(d));
    }
}

