/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.misc.t0008.internal;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.tests.modeling.misc.t0008.ITestChildElement;
import org.eclipse.sapphire.tests.modeling.misc.t0008.ITestRootElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestRootElement
extends ModelElement
implements ITestRootElement {
    private ModelElementList<ITestChildElement> children;
    private ModelElementList<ITestChildElement> childrenReadOnly;

    public TestRootElement(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public TestRootElement(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<ITestChildElement> getChildren() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.children == null) {
                this.refresh((ModelProperty)PROP_CHILDREN, true);
            }
            return this.children;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<ITestChildElement> getChildrenReadOnly() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.childrenReadOnly == null) {
                this.refresh((ModelProperty)PROP_CHILDREN_READ_ONLY, true);
            }
            return this.childrenReadOnly;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_CHILDREN) {
                if (this.children == null) {
                    if (force) {
                        this.children = new ModelElementList((IModelElement)this, PROP_CHILDREN);
                        ListBindingImpl binding = this.resource().binding(PROP_CHILDREN);
                        this.children.init(binding);
                        this.refreshPropertyEnablement((ModelProperty)PROP_CHILDREN);
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_CHILDREN);
                    boolean notified = this.children.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_CHILDREN, enablementRefreshResult);
                    }
                }
            } else if (property == PROP_CHILDREN_READ_ONLY) {
                if (this.childrenReadOnly == null) {
                    if (force) {
                        this.childrenReadOnly = new ModelElementList((IModelElement)this, PROP_CHILDREN_READ_ONLY);
                        ListBindingImpl binding = this.resource().binding(PROP_CHILDREN_READ_ONLY);
                        this.childrenReadOnly.init(binding);
                        this.refreshPropertyEnablement((ModelProperty)PROP_CHILDREN_READ_ONLY);
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_CHILDREN_READ_ONLY);
                    boolean notified = this.childrenReadOnly.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_CHILDREN_READ_ONLY, enablementRefreshResult);
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_CHILDREN) {
            return this.getChildren();
        }
        if (property == PROP_CHILDREN_READ_ONLY) {
            return this.getChildrenReadOnly();
        }
        return super.read(property);
    }
}

