/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.modeling.el.FailSafeFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.ui.SapphireActionLocationHint;
import org.eclipse.sapphire.ui.SapphireActionLocationHintAfter;
import org.eclipse.sapphire.ui.SapphireActionLocationHintBefore;
import org.eclipse.sapphire.ui.def.ISapphireActionImage;
import org.eclipse.sapphire.ui.def.ISapphireActionLocationHint;
import org.eclipse.sapphire.ui.def.ISapphireActionLocationHintAfter;
import org.eclipse.sapphire.ui.def.ISapphireActionLocationHintBefore;
import org.eclipse.sapphire.ui.def.ISapphireActionSystemPartDef;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.renderers.swt.SwtRendererUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SapphireActionSystemPart {
    public static final String EVENT_ID_CHANGED = "id";
    public static final String EVENT_LABEL_CHANGED = "label";
    public static final String EVENT_IMAGES_CHANGED = "image";
    public static final String EVENT_LOCATION_HINTS_CHANGED = "location-hints";
    public static final String EVENT_ENABLEMENT_STATE_CHANGED = "enablement";
    public static final String EVENT_CHECKED_STATE_CHANGED = "checked";
    private FunctionContext functionContext;
    private String id;
    private FunctionResult labelFunctionResult;
    private final List<ImageDescriptor> images = new CopyOnWriteArrayList<ImageDescriptor>();
    private final List<SapphireActionLocationHint> locationHints = new CopyOnWriteArrayList<SapphireActionLocationHint>();
    private final List<SapphireActionLocationHint> locationHintsReadOnly = Collections.unmodifiableList(this.locationHints);
    private boolean enabled;
    private boolean checked;
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();

    protected final void init(ISapphireActionSystemPartDef def) {
        this.functionContext = this.initFunctionContext();
        if (def != null) {
            this.id = (String)def.getId().getContent();
            Function labelFunction = FailSafeFunction.create((Function)((Function)def.getLabel().getContent()), (Function)Literal.create(String.class));
            this.labelFunctionResult = labelFunction.evaluate(this.functionContext);
            this.labelFunctionResult.addListener(new FunctionResult.Listener(){

                public void handleValueChanged() {
                    SapphireActionSystemPart.this.notifyListeners(new Event(SapphireActionSystemPart.EVENT_LABEL_CHANGED));
                }
            });
            for (ISapphireActionImage image : def.getImages()) {
                ImageDescriptor img;
                Function imageFunction = FailSafeFunction.create((Function)((Function)image.getImage().getContent()), (Function)Literal.create(ImageData.class));
                FunctionResult imageFunctionResult = imageFunction.evaluate(this.functionContext);
                ImageData data = (ImageData)imageFunctionResult.value();
                if (data != null && (img = SwtRendererUtil.toImageDescriptor(data)) != null) {
                    this.images.add(img);
                }
                imageFunctionResult.dispose();
            }
            for (ISapphireActionLocationHint locationHintDef : def.getLocationHints()) {
                SapphireActionLocationHint locationHint;
                String locationHintText = (String)locationHintDef.getReferenceEntityId().getContent();
                if (locationHintText == null) continue;
                if (locationHintDef instanceof ISapphireActionLocationHintBefore) {
                    locationHint = new SapphireActionLocationHintBefore(locationHintText);
                } else if (locationHintDef instanceof ISapphireActionLocationHintAfter) {
                    locationHint = new SapphireActionLocationHintAfter(locationHintText);
                } else {
                    throw new IllegalStateException();
                }
                this.locationHints.add(locationHint);
            }
        }
        this.enabled = true;
    }

    protected abstract FunctionContext initFunctionContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getId() {
        SapphireActionSystemPart sapphireActionSystemPart = this;
        synchronized (sapphireActionSystemPart) {
            return this.id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setId(String id) {
        SapphireActionSystemPart sapphireActionSystemPart = this;
        synchronized (sapphireActionSystemPart) {
            this.id = id;
        }
        this.notifyListeners(new Event(EVENT_ID_CHANGED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getLabel() {
        SapphireActionSystemPart sapphireActionSystemPart = this;
        synchronized (sapphireActionSystemPart) {
            return this.labelFunctionResult == null ? null : (String)this.labelFunctionResult.value();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLabel(String label) {
        SapphireActionSystemPart sapphireActionSystemPart = this;
        synchronized (sapphireActionSystemPart) {
            this.labelFunctionResult = Literal.create((Object)label).evaluate(this.functionContext);
        }
        this.notifyListeners(new Event(EVENT_LABEL_CHANGED));
    }

    public final ImageDescriptor getImage(int size) {
        for (ImageDescriptor image : this.images) {
            if (image.getImageData().height != size) continue;
            return image;
        }
        return null;
    }

    public final void addImage(ImageDescriptor image) {
        if (image == null) {
            throw new IllegalArgumentException();
        }
        this.images.add(image);
        this.notifyListeners(new Event(EVENT_IMAGES_CHANGED));
    }

    public final void removeImage(ImageDescriptor image) {
        if (image == null) {
            throw new IllegalArgumentException();
        }
        this.images.remove(image);
        this.notifyListeners(new Event(EVENT_IMAGES_CHANGED));
    }

    public final List<SapphireActionLocationHint> getLocationHints() {
        return this.locationHintsReadOnly;
    }

    public final void addLocationHint(SapphireActionLocationHint locationHint) {
        if (locationHint == null) {
            throw new IllegalArgumentException();
        }
        this.locationHints.add(locationHint);
        this.notifyListeners(new Event(EVENT_LOCATION_HINTS_CHANGED));
    }

    public final void removeLocationHint(String locationHint) {
        if (locationHint == null) {
            throw new IllegalArgumentException();
        }
        this.locationHints.remove(locationHint);
        this.notifyListeners(new Event(EVENT_LOCATION_HINTS_CHANGED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        SapphireActionSystemPart sapphireActionSystemPart = this;
        synchronized (sapphireActionSystemPart) {
            return this.enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean enabled) {
        boolean changed = false;
        SapphireActionSystemPart sapphireActionSystemPart = this;
        synchronized (sapphireActionSystemPart) {
            if (this.enabled != enabled) {
                this.enabled = enabled;
                changed = true;
            }
        }
        if (changed) {
            this.notifyListeners(new Event(EVENT_ENABLEMENT_STATE_CHANGED));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChecked() {
        SapphireActionSystemPart sapphireActionSystemPart = this;
        synchronized (sapphireActionSystemPart) {
            return this.checked;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChecked(boolean checked) {
        boolean changed = false;
        SapphireActionSystemPart sapphireActionSystemPart = this;
        synchronized (sapphireActionSystemPart) {
            if (this.checked != checked) {
                this.checked = checked;
                changed = true;
            }
        }
        if (changed) {
            this.notifyListeners(new Event(EVENT_CHECKED_STATE_CHANGED));
        }
    }

    public final void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public final void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    protected final void notifyListeners(Event event) {
        for (Listener listener : this.listeners) {
            try {
                listener.handleEvent(event);
            }
            catch (Exception e) {
                SapphireUiFrameworkPlugin.log(e);
            }
        }
    }

    public static class Event {
        private final String type;

        public Event(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }

    public static abstract class Listener {
        public abstract void handleEvent(Event var1);
    }
}

