/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.util.MutableReference;
import org.eclipse.sapphire.ui.SapphirePageBook;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphirePageBookExtDef;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.renderers.swt.DefaultListPropertyEditorRenderer;
import org.eclipse.sapphire.ui.swt.SapphireControl;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphireListControlledPageBook
extends SapphirePageBook {
    @Override
    protected Object parsePageKey(String pageKeyString) {
        ISapphireUiDef rootdef = (ISapphireUiDef)this.definition.nearest(ISapphireUiDef.class);
        Class<?> cl = rootdef.resolveClass(pageKeyString);
        return SapphirePageBook.ClassBasedKey.create(cl);
    }

    @Override
    public void render(SapphireRenderingContext context) {
        super.render(context);
        final IModelElement element = this.getModelElement();
        ListProperty property = (ListProperty)this.resolve((String)((ISapphirePageBookExtDef)this.definition).getControlProperty().getContent());
        Table table = SapphireListControlledPageBook.findControlForProperty((Control)context.getComposite(), element, (ModelProperty)property, Table.class);
        ISelectionProvider selectionProvider = (ISelectionProvider)table.getData("selection.provider");
        final MutableReference selectedModelElementRef = new MutableReference();
        selectionProvider.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SapphirePageBook.ClassBasedKey newPageKey;
                IModelElement newModelElement;
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (!sel.isEmpty()) {
                    newModelElement = ((DefaultListPropertyEditorRenderer.TableRow)sel.getFirstElement()).element();
                    newPageKey = SapphirePageBook.ClassBasedKey.create(newModelElement);
                } else {
                    newModelElement = element;
                    newPageKey = null;
                }
                if (selectedModelElementRef.get() != newModelElement) {
                    selectedModelElementRef.set((Object)newModelElement);
                    Runnable inputChangeOperation = new Runnable(){

                        public void run() {
                            SapphireListControlledPageBook.this.changePage(newModelElement, newPageKey);
                        }
                    };
                    Display.getDefault().syncExec(inputChangeOperation);
                }
            }
        });
        this.changePage(element, null);
    }

    private static <T> T findControlForProperty(Control context, IModelElement element, ModelProperty property, Class<T> type) {
        Control root = context;
        while (!(root instanceof Section) && !(root instanceof SapphireControl)) {
            Composite parent = root.getParent();
            if (parent instanceof Shell) break;
            root = parent;
        }
        return SapphireListControlledPageBook.findControlForPropertyHelper(root, element, property, type);
    }

    private static <T> T findControlForPropertyHelper(Control context, IModelElement element, ModelProperty property, Class<T> type) {
        if (context.getData("element") == element && context.getData("property") == property && type.isAssignableFrom(context.getClass())) {
            return (T)context;
        }
        if (context instanceof Composite) {
            Control[] controlArray = ((Composite)context).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                T control = SapphireListControlledPageBook.findControlForPropertyHelper(child, element, property, type);
                if (control != null) {
                    return control;
                }
                ++n2;
            }
        }
        return null;
    }
}

