/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.internal.binding;

import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueNormalizationService;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.ui.DelayedTasksExecutor;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.internal.binding.AbstractBinding;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class TextFieldBinding
extends AbstractBinding {
    private Text text;
    private String textContent;
    private ValueNormalizationService valueNormalizationService;
    private DelayedTasksExecutor.Task onTextContentModifyTask;

    public TextFieldBinding(SapphirePropertyEditor editor, SapphireRenderingContext context, Text text) {
        super(editor, context, (Control)text);
    }

    protected void initialize(SapphirePropertyEditor editor, SapphireRenderingContext context, Control control) {
        super.initialize(editor, context, control);
        this.onTextContentModifyTask = new DelayedTasksExecutor.Task(){

            public int getPriority() {
                return 100;
            }

            public void run() {
                TextFieldBinding.this.updateModel();
                TextFieldBinding.this.updateTargetAttributes();
            }
        };
        this.text = (Text)control;
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                TextFieldBinding.this.updateTextContent(TextFieldBinding.this.text.getText());
            }
        });
        this.valueNormalizationService = (ValueNormalizationService)editor.getLocalModelElement().service(editor.getProperty(), ValueNormalizationService.class);
    }

    protected void updateTextContent(String textContent) {
        this.textContent = textContent;
        DelayedTasksExecutor.schedule(this.onTextContentModifyTask);
    }

    protected void doUpdateModel() {
        if (!this.text.isDisposed() && (this.text.getStyle() & 8) == 0) {
            this.getModelElement().write((ValueProperty)this.getProperty(), (Object)this.textContent);
        }
    }

    protected void doUpdateTarget() {
        String newValue;
        String oldValue = this.valueNormalizationService.normalize(this.text.getText());
        if (!MiscUtil.equal((Object)oldValue, (Object)(newValue = this.valueNormalizationService.normalize(((Value)this.getPropertyValue()).getText(false))))) {
            this.text.setText(newValue == null ? "" : newValue);
        }
    }
}

