/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import javax.xml.namespace.QName;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LayeredListBindingImpl;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.modeling.xml.ChildXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.XmlUtil;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;
import org.eclipse.sapphire.services.PossibleTypesService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardXmlListBindingImpl
extends LayeredListBindingImpl {
    private PossibleTypesService possibleTypesService;
    private Listener possibleTypesServiceListener;
    protected XmlPath path;
    protected QName[] xmlElementNames;
    protected ModelElementType[] modelElementTypes;

    public void init(final IModelElement element, final ModelProperty property, final String[] params) {
        super.init(element, property, params);
        this.possibleTypesService = (PossibleTypesService)element.service(property, PossibleTypesService.class);
        this.possibleTypesServiceListener = new Listener(){

            public void handle(Event event) {
                try {
                    StandardXmlListBindingImpl.this.initBindingMetadata(element, property, params);
                }
                catch (Exception e) {
                    String msg = NLS.bind((String)Resources.failure, (Object[])new Object[]{element.getModelElementType().getSimpleName(), property.getName(), e.getMessage()});
                    LoggingService.log((Status)Status.createErrorStatus((String)msg));
                }
            }
        };
        this.possibleTypesService.attach(this.possibleTypesServiceListener);
        try {
            this.initBindingMetadata(element, property, params);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)Resources.failure, (Object[])new Object[]{element.getModelElementType().getSimpleName(), property.getName(), e.getMessage()});
            throw new RuntimeException(msg, e);
        }
    }

    protected void initBindingMetadata(IModelElement element, ModelProperty property, String[] params) {
        XmlListBinding annotation = (XmlListBinding)property.getAnnotation(XmlListBinding.class);
        XmlNamespaceResolver xmlNamespaceResolver = ((XmlResource)element.resource()).getXmlNamespaceResolver();
        SortedSet possible = this.possibleTypesService.types();
        this.modelElementTypes = possible.toArray(new ModelElementType[possible.size()]);
        if (annotation == null) {
            this.path = new XmlPath(property.getName(), xmlNamespaceResolver);
            this.xmlElementNames = new QName[this.modelElementTypes.length];
            int i = 0;
            while (i < this.modelElementTypes.length) {
                this.xmlElementNames[i] = this.createDefaultElementName(this.modelElementTypes[i], xmlNamespaceResolver);
                ++i;
            }
        } else {
            if (annotation.path().length() > 0) {
                this.path = new XmlPath(annotation.path(), xmlNamespaceResolver);
            }
            XmlListBinding.Mapping[] mappings = annotation.mappings();
            this.xmlElementNames = new QName[this.modelElementTypes.length];
            int i = 0;
            while (i < this.modelElementTypes.length) {
                ModelElementType type = this.modelElementTypes[i];
                XmlListBinding.Mapping[] mappingArray = mappings;
                int n = mappings.length;
                int n2 = 0;
                while (n2 < n) {
                    XmlListBinding.Mapping mapping = mappingArray[n2];
                    if (mapping.type() == type.getModelElementClass()) {
                        String mappingElementName = mapping.element().trim();
                        if (mappingElementName.length() == 0) {
                            throw new RuntimeException(Resources.mustSpecifyElementNameMsg);
                        }
                        this.xmlElementNames[i] = XmlUtil.createQualifiedName(mappingElementName, xmlNamespaceResolver);
                        break;
                    }
                    ++n2;
                }
                if (this.xmlElementNames[i] == null) {
                    this.xmlElementNames[i] = this.createDefaultElementName(type, xmlNamespaceResolver);
                }
                ++i;
            }
        }
    }

    protected QName createDefaultElementName(ModelElementType type, XmlNamespaceResolver xmlNamespaceResolver) {
        return XmlUtil.createDefaultElementName(type);
    }

    public ModelElementType type(Resource resource) {
        XmlElement xmlElement = ((XmlResource)resource).getXmlElement();
        QName xmlElementName = XmlUtil.createQualifiedName(xmlElement.getDomNode());
        String xmlElementNamespace = xmlElementName.getNamespaceURI();
        int i = 0;
        while (i < this.xmlElementNames.length) {
            if (XmlUtil.equal(this.xmlElementNames[i], xmlElementName, xmlElementNamespace)) {
                return this.modelElementTypes[i];
            }
            ++i;
        }
        throw new IllegalStateException();
    }

    protected List<?> readUnderlyingList() {
        XmlElement parent = this.getXmlElement(false);
        if (parent == null) {
            return Collections.emptyList();
        }
        ArrayList<XmlElement> list = new ArrayList<XmlElement>();
        for (XmlElement element : parent.getChildElements()) {
            QName xmlElementName = XmlUtil.createQualifiedName(element.getDomNode());
            if (!XmlUtil.contains(this.xmlElementNames, xmlElementName, xmlElementName.getNamespaceURI())) continue;
            list.add(element);
        }
        return list;
    }

    protected Object addUnderlyingObject(ModelElementType type) {
        XmlElement parent = this.getXmlElement(true);
        QName xmlElementName = this.xmlElementNames[MiscUtil.indexOf((Object[])this.modelElementTypes, (Object)type)];
        if (xmlElementName.getNamespaceURI().equals("")) {
            xmlElementName = new QName(parent.getNamespace(), xmlElementName.getLocalPart());
        }
        return parent.addChildElement(xmlElementName);
    }

    protected Resource createResource(Object obj) {
        XmlElement xmlElement = (XmlElement)obj;
        XmlResource parentXmlResource = (XmlResource)this.element().resource();
        return new ChildXmlResource(parentXmlResource, xmlElement);
    }

    public void remove(Resource resource) {
        XmlElement parent;
        XmlElement base;
        XmlResource xmlResource = (XmlResource)resource;
        XmlElement xmlElement = xmlResource.getXmlElement();
        xmlElement.remove();
        if (this.path != null && (base = this.getBaseXmlElement(false)) != null && (parent = (XmlElement)base.getChildNode(this.path, false)) != null && parent.isEmpty()) {
            base.removeChildNode(this.path);
        }
    }

    public void swap(Resource a, Resource b) {
        XmlElement x = ((XmlResource)a).getXmlElement();
        XmlElement y = ((XmlResource)b).getXmlElement();
        x.swap(y);
    }

    protected XmlElement getXmlElement(boolean createIfNecessary) {
        XmlElement parent = this.getBaseXmlElement(createIfNecessary);
        if (parent != null && this.path != null) {
            parent = (XmlElement)parent.getChildNode(this.path, createIfNecessary);
        }
        return parent;
    }

    protected XmlElement getBaseXmlElement(boolean createIfNecessary) {
        XmlResource resource = (XmlResource)this.element().resource();
        return resource.getXmlElement(createIfNecessary);
    }

    public void dispose() {
        super.dispose();
        if (this.possibleTypesService != null) {
            this.possibleTypesService.detach(this.possibleTypesServiceListener);
        }
    }

    private static final class Resources
    extends NLS {
        public static String failure;
        public static String mustSpecifyElementNameMsg;

        static {
            Resources.initializeMessages((String)StandardXmlListBindingImpl.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

