/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.LoggingService;

public final class ListenerContext {
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();

    public void attach(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.add(listener);
    }

    public void detach(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.remove(listener);
    }

    public void broadcast(Event event) {
        for (Listener listener : this.listeners) {
            try {
                listener.handle(event);
            }
            catch (Exception e) {
                LoggingService.log(e);
            }
        }
    }

    public void broadcast() {
        this.broadcast(new Event());
    }
}

