/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelElementListener;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelParticle;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.ValidationStateChangeEvent;
import org.eclipse.sapphire.services.PossibleTypesService;
import org.eclipse.sapphire.services.ValidationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelElementList<T extends IModelElement>
extends ModelParticle
implements List<T>,
IModelParticle {
    private final ListProperty property;
    private final boolean readonly;
    private final PossibleTypesService possibleTypesService;
    private ListBindingImpl binding;
    private List<IModelElement> data;
    private Status valres;
    private ModelElementListener listMemberListener;

    public ModelElementList(IModelElement parent, ListProperty property) {
        super(parent, parent.resource());
        this.property = property;
        this.readonly = property.isReadOnly();
        this.possibleTypesService = parent.service(property, PossibleTypesService.class);
        this.data = Collections.emptyList();
        this.valres = null;
        this.listMemberListener = new ModelElementListener(){

            public void validationStateChanged(ValidationStateChangeEvent event) {
                ModelElementList.this.refreshValidationResult(true);
            }
        };
    }

    public final void init(ListBindingImpl binding) {
        this.binding = binding;
        this.refresh();
    }

    @Override
    public IModelElement parent() {
        return (IModelElement)super.parent();
    }

    public ListProperty getParentProperty() {
        return this.property;
    }

    @Override
    public synchronized Status validate() {
        if (this.valres == null) {
            this.refreshValidationResult(false);
        }
        return this.valres;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refresh() {
        if (this.binding == null) {
            throw new IllegalStateException();
        }
        boolean changed = false;
        ModelElementList modelElementList = this;
        synchronized (modelElementList) {
            boolean refreshNeeded;
            List<Resource> newResources = this.binding.read();
            int newContentSize = newResources.size();
            if (this.data.size() == newContentSize) {
                refreshNeeded = false;
                int i = 0;
                while (i < newContentSize) {
                    if (this.data.get(i).resource() != newResources.get(i)) {
                        refreshNeeded = true;
                        break;
                    }
                    ++i;
                }
            } else {
                refreshNeeded = true;
            }
            if (refreshNeeded) {
                ArrayList<IModelElement> newContent = new ArrayList<IModelElement>(newContentSize);
                for (Resource resource : newResources) {
                    IModelElement modelElement = null;
                    for (IModelElement x : this.data) {
                        if (resource != x.resource()) continue;
                        modelElement = x;
                        break;
                    }
                    if (modelElement == null) {
                        ModelElementType type = this.binding.type(resource);
                        modelElement = type.instantiate(this, this.property, resource);
                    }
                    newContent.add(modelElement);
                }
                for (IModelElement x : this.data) {
                    boolean retained = false;
                    for (IModelElement y : newContent) {
                        if (x != y) continue;
                        retained = true;
                        break;
                    }
                    if (retained) continue;
                    try {
                        x.dispose();
                    }
                    catch (Exception e) {
                        LoggingService.log(e);
                    }
                }
                this.data = newContent;
                for (IModelElement modelElement : this) {
                    modelElement.addListener(this.listMemberListener);
                }
                changed = true;
            }
        }
        if (changed) {
            this.parent().notifyPropertyChangeListeners(this.property);
        }
        this.refreshValidationResult(true);
        return changed;
    }

    private void refreshValidationResult(boolean notifyListenersIfChanged) {
        Status.CompositeStatusFactory factory = Status.factoryForComposite();
        for (ValidationService svc : this.parent().services(this.property, ValidationService.class)) {
            try {
                factory.merge(svc.validate());
            }
            catch (Exception e) {
                LoggingService.log(e);
            }
        }
        for (IModelElement item : this) {
            factory.add(item.validate());
        }
        Status st = factory.create();
        if (this.valres == null) {
            this.valres = st;
        } else if (!this.valres.equals(st)) {
            this.valres = st;
            if (notifyListenersIfChanged) {
                this.parent().notifyPropertyChangeListeners(this.property);
            }
        }
    }

    public T addNewElement() {
        this.ensureNotReadOnly();
        return this.addNewElement(this.possibleTypesService.types().first());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T addNewElement(ModelElementType type) {
        this.ensureNotReadOnly();
        IModelElement newElement = null;
        ModelElementList modelElementList = this;
        synchronized (modelElementList) {
            Resource newResource = this.binding.add(type);
            this.refresh();
            for (IModelElement element : this.data) {
                if (element.resource() != newResource) continue;
                newElement = element;
                break;
            }
        }
        return (T)newElement;
    }

    public <C extends IModelElement> C addNewElement(Class<C> cl) {
        this.ensureNotReadOnly();
        ModelElementType type = ModelElementType.getModelElementType(cl);
        if (type == null) {
            throw new IllegalArgumentException();
        }
        return (C)this.addNewElement(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveUp(T modelElement) {
        this.ensureNotReadOnly();
        ModelElementList modelElementList = this;
        synchronized (modelElementList) {
            int index = this.indexOf(modelElement);
            if (index == -1) {
                throw new IllegalArgumentException();
            }
            if (index > 0) {
                IModelElement previousModelElement = this.data.get(index - 1);
                this.swap(modelElement, previousModelElement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveDown(T modelElement) {
        this.ensureNotReadOnly();
        ModelElementList modelElementList = this;
        synchronized (modelElementList) {
            int index = this.indexOf(modelElement);
            if (index == -1) {
                throw new IllegalArgumentException();
            }
            if (index < this.data.size() - 1) {
                IModelElement nextModelElement = this.data.get(index + 1);
                this.swap(modelElement, nextModelElement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swap(T a, T b) {
        this.ensureNotReadOnly();
        ModelElementList modelElementList = this;
        synchronized (modelElementList) {
            if (this.data.indexOf(a) == -1 || this.data.indexOf(b) == -1) {
                throw new IllegalArgumentException();
            }
            this.binding.swap(a.resource(), b.resource());
            this.refresh();
        }
    }

    @Override
    public synchronized boolean remove(Object object) {
        this.ensureNotReadOnly();
        if (this.contains(object)) {
            Resource resource = ((IModelElement)object).resource();
            this.binding.remove(resource);
            this.refresh();
            return true;
        }
        return false;
    }

    @Override
    public synchronized T remove(int index) {
        this.ensureNotReadOnly();
        IModelElement element = this.data.get(index);
        this.remove(element);
        return (T)element;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> collection) {
        this.ensureNotReadOnly();
        boolean changed = false;
        for (Object object : collection) {
            boolean bl = changed = this.remove(object) || changed;
        }
        return changed;
    }

    @Override
    public synchronized boolean retainAll(Collection<?> collection) {
        this.ensureNotReadOnly();
        boolean changed = false;
        for (IModelElement element : this) {
            if (collection.contains(element)) continue;
            boolean bl = changed = this.remove(element) || changed;
        }
        return changed;
    }

    @Override
    public synchronized void clear() {
        this.ensureNotReadOnly();
        for (IModelElement element : this) {
            this.remove(element);
        }
    }

    @Override
    public synchronized T get(int index) {
        return (T)this.data.get(index);
    }

    @Override
    public synchronized int indexOf(Object object) {
        return this.data.indexOf(object);
    }

    @Override
    public synchronized int lastIndexOf(Object object) {
        return this.data.lastIndexOf(object);
    }

    @Override
    public synchronized boolean contains(Object object) {
        return this.data.contains(object);
    }

    @Override
    public synchronized boolean containsAll(Collection<?> collection) {
        return this.data.containsAll(collection);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public synchronized int size() {
        return this.data.size();
    }

    @Override
    public synchronized Iterator<T> iterator() {
        return new Itr<IModelElement>(this.data.iterator());
    }

    @Override
    public synchronized ListIterator<T> listIterator() {
        return new ListItr<IModelElement>(this.data.listIterator());
    }

    @Override
    public synchronized ListIterator<T> listIterator(int index) {
        return new ListItr<IModelElement>(this.data.listIterator(index));
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized Object[] toArray() {
        return this.data.toArray();
    }

    @Override
    public synchronized <E> E[] toArray(E[] array) {
        return this.data.toArray(array);
    }

    @Override
    public boolean add(T object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException();
    }

    private void ensureNotReadOnly() {
        if (this.readonly) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Itr<T>
    implements Iterator<T> {
        private final Iterator<T> baseIterator;

        public Itr(Iterator<T> baseIterator) {
            this.baseIterator = baseIterator;
        }

        @Override
        public boolean hasNext() {
            return this.baseIterator.hasNext();
        }

        @Override
        public T next() {
            return this.baseIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ListItr<T>
    extends Itr<T>
    implements ListIterator<T> {
        private final ListIterator<T> baseIterator;

        public ListItr(ListIterator<T> baseIterator) {
            super(baseIterator);
            this.baseIterator = baseIterator;
        }

        @Override
        public int nextIndex() {
            return this.baseIterator.nextIndex();
        }

        @Override
        public boolean hasPrevious() {
            return this.baseIterator.hasPrevious();
        }

        @Override
        public T previous() {
            return this.baseIterator.previous();
        }

        @Override
        public int previousIndex() {
            return this.baseIterator.previousIndex();
        }

        @Override
        public void add(T object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(T object) {
            throw new UnsupportedOperationException();
        }
    }
}

