/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelParticle;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.services.DefaultValueService;
import org.eclipse.sapphire.services.ValidationService;
import org.eclipse.sapphire.services.ValueSerializationMasterService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Value<T>
extends ModelParticle {
    private final ValueProperty property;
    private final String raw;
    private final T parsed;
    private Status valres;
    private boolean defaultValueInitialized;
    private String defaultText;
    private T defaultContent;

    public Value(IModelElement parent, ValueProperty property, String value) {
        super(parent, parent.resource());
        this.property = property;
        this.raw = this.normalize(value);
        this.parsed = this.parse(property.decodeKeywords(this.raw));
        this.valres = null;
        this.defaultValueInitialized = false;
        this.defaultText = null;
        this.defaultContent = null;
    }

    public void init() {
        this.initValidation();
        this.initDefaultValue();
    }

    private void initValidation() {
        if (this.valres == null) {
            Status.CompositeStatusFactory factory = Status.factoryForComposite();
            for (ValidationService svc : this.parent().services(this.property, ValidationService.class)) {
                try {
                    factory.merge(svc.validate());
                }
                catch (Exception e) {
                    LoggingService.log(e);
                }
            }
            this.valres = factory.create();
        }
    }

    private void initDefaultValue() {
        if (!this.defaultValueInitialized) {
            DefaultValueService defaultValueService = this.parent().service(this.property, DefaultValueService.class);
            this.defaultText = defaultValueService == null ? null : this.normalize(defaultValueService.value());
            this.defaultContent = this.parse(this.property.decodeKeywords(this.defaultText));
            this.defaultValueInitialized = true;
        }
    }

    @Override
    public IModelElement parent() {
        return (IModelElement)super.parent();
    }

    public ValueProperty getProperty() {
        return this.property;
    }

    public String getText() {
        return this.getText(true);
    }

    public String getText(boolean useDefaultValue) {
        if (this.raw != null) {
            return this.raw;
        }
        if (useDefaultValue) {
            return this.getDefaultText();
        }
        return null;
    }

    public String getLocalizedText() {
        return this.getLocalizedText(true);
    }

    public String getLocalizedText(boolean useDefaultValue) {
        return this.getLocalizedText(useDefaultValue, CapitalizationType.NO_CAPS, true);
    }

    public String getLocalizedText(CapitalizationType capitalizationType, boolean includeMnemonic) {
        return this.getLocalizedText(true, capitalizationType, includeMnemonic);
    }

    public String getLocalizedText(boolean useDefaultValue, CapitalizationType capitalizationType, boolean includeMnemonic) {
        String sourceLangText = this.getText(useDefaultValue);
        if (sourceLangText != null) {
            return this.adapt(LocalizationService.class).text(sourceLangText, capitalizationType, includeMnemonic);
        }
        return null;
    }

    public T getContent() {
        return this.getContent(true);
    }

    public T getContent(boolean useDefaultValue) {
        if (this.parsed != null) {
            return this.parsed;
        }
        if (useDefaultValue) {
            return this.getDefaultContent();
        }
        return null;
    }

    public boolean isDefault() {
        return this.raw == null;
    }

    public T getDefaultContent() {
        this.initDefaultValue();
        return this.defaultContent;
    }

    public String getDefaultText() {
        this.initDefaultValue();
        return this.defaultText;
    }

    public boolean isMalformed() {
        if (this.isDefault()) {
            this.initDefaultValue();
            return this.defaultText != null && this.defaultContent == null;
        }
        return this.raw != null && this.parsed == null;
    }

    @Override
    public Status validate() {
        this.initValidation();
        return this.valres;
    }

    public boolean equals(Object val) {
        if (this == val) {
            return true;
        }
        if (val == null || !(val instanceof Value)) {
            return false;
        }
        this.init();
        Value value = (Value)val;
        return this.parent() == value.parent() && this.property == value.property && MiscUtil.equal(this.raw, value.raw) && this.valres.equals(value.valres) && MiscUtil.equal(this.defaultText, value.defaultText);
    }

    public int hashCode() {
        int hashCode = this.parent().hashCode();
        hashCode ^= this.property.hashCode();
        return hashCode ^= this.raw == null ? 1 : this.raw.hashCode();
    }

    public String toString() {
        return this.raw == null ? "<null>" : this.raw;
    }

    private T parse(String str) {
        if (str == null) {
            return null;
        }
        return (T)this.parent().service(this.property, ValueSerializationMasterService.class).decode(str);
    }

    private String normalize(String str) {
        if (str != null && str.length() == 0) {
            str = null;
        }
        return str;
    }
}

