/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.modeling.el.ConcatFunction;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionException;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Function {
    private Object origin;
    private boolean originInitialized;
    private List<Function> operands;
    private List<Function> operandsReadOnly;

    public final void init(Function ... operands) {
        int count = operands.length;
        if (count == 0) {
            this.operands = Collections.emptyList();
            this.operandsReadOnly = this.operands;
        } else if (count == 1) {
            this.operands = Collections.singletonList(operands[0]);
            this.operandsReadOnly = this.operands;
        } else {
            this.operands = new ArrayList<Function>(count);
            Function[] functionArray = operands;
            int n = operands.length;
            int n2 = 0;
            while (n2 < n) {
                Function operand = functionArray[n2];
                this.operands.add(operand);
                ++n2;
            }
            this.operandsReadOnly = Collections.unmodifiableList(this.operands);
        }
    }

    public final void init(List<Function> operands) {
        int count = operands.size();
        if (count == 0) {
            this.operands = Collections.emptyList();
            this.operandsReadOnly = this.operands;
        } else if (count == 1) {
            this.operands = Collections.singletonList(operands.get(0));
            this.operandsReadOnly = this.operands;
        } else {
            this.operands = new ArrayList<Function>(count);
            this.operands.addAll(operands);
            this.operandsReadOnly = Collections.unmodifiableList(this.operands);
        }
    }

    public final void initOrigin(Object origin, boolean applyToOperands) {
        if (this.originInitialized) {
            throw new IllegalStateException();
        }
        this.origin = origin;
        if (applyToOperands) {
            for (Function operand : this.operands) {
                operand.initOrigin(origin, true);
            }
        }
    }

    public final Object origin() {
        return this.origin;
    }

    public abstract String name();

    public boolean operator() {
        return false;
    }

    public int precedence() {
        return 1;
    }

    public final List<Function> operands() {
        return this.operandsReadOnly;
    }

    public final Function operand(int position) {
        if (position < this.operands.size()) {
            return this.operands.get(position);
        }
        throw new FunctionException(NLS.bind(Resources.missingOperandMessage, this.getClass().getName(), String.valueOf(position)));
    }

    public abstract FunctionResult evaluate(FunctionContext var1);

    public final String toString() {
        StringBuilder buf = new StringBuilder();
        if (this instanceof Literal || this instanceof ConcatFunction) {
            this.toString(buf, true);
        } else {
            buf.append("${ ");
            this.toString(buf, false);
            buf.append(" }");
        }
        return buf.toString();
    }

    public void toString(StringBuilder buf, boolean topLevel) {
        String name = this.name();
        if (this.operator()) {
            int precedence = this.precedence();
            boolean first = true;
            boolean addOperatorBeforeNext = this.operands.size() == 1;
            for (Function operand : this.operands) {
                boolean parens;
                if (addOperatorBeforeNext) {
                    if (first) {
                        first = false;
                    } else {
                        buf.append(' ');
                    }
                    buf.append(name);
                    buf.append(' ');
                } else {
                    addOperatorBeforeNext = true;
                    first = false;
                }
                boolean bl = parens = precedence < operand.precedence();
                if (parens) {
                    buf.append("( ");
                }
                operand.toString(buf, false);
                if (!parens) continue;
                buf.append(" )");
            }
        } else {
            buf.append(name);
            buf.append('(');
            if (!this.operands.isEmpty()) {
                boolean first = true;
                for (Function operand : this.operands) {
                    if (first) {
                        buf.append(',');
                    } else {
                        first = false;
                    }
                    buf.append(' ');
                    operand.toString(buf, false);
                }
                buf.append(' ');
            }
            buf.append(')');
        }
    }

    private static final class Resources
    extends NLS {
        public static String missingOperandMessage;

        static {
            Resources.initializeMessages(Function.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

