/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.sdk.build.processor.internal.util;

import com.sun.mirror.type.PrimitiveType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.sapphire.sdk.build.processor.internal.util.ArrayTypeReference;
import org.eclipse.sapphire.sdk.build.processor.internal.util.ParameterizedTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeReference
implements Comparable<TypeReference> {
    public static final Map<PrimitiveType.Kind, TypeReference> PRIMITIVE_TYPES = new HashMap<PrimitiveType.Kind, TypeReference>();
    public static final TypeReference VOID_TYPE;
    public static final TypeReference BOOLEAN_TYPE;
    public static final TypeReference WILDCARD_TYPE_PARAM;
    private final String qualifiedName;
    private final String simpleName;
    private final String packageName;

    static {
        PrimitiveType.Kind[] kindArray = PrimitiveType.Kind.values();
        int n = kindArray.length;
        int n2 = 0;
        while (n2 < n) {
            PrimitiveType.Kind typeKind = kindArray[n2];
            PRIMITIVE_TYPES.put(typeKind, new TypeReference(typeKind.name().toLowerCase()));
            ++n2;
        }
        VOID_TYPE = new TypeReference("void");
        BOOLEAN_TYPE = PRIMITIVE_TYPES.get(PrimitiveType.Kind.BOOLEAN);
        WILDCARD_TYPE_PARAM = new TypeReference("?");
    }

    public TypeReference(String qualifiedName) {
        this.qualifiedName = qualifiedName;
        int lastDot = this.qualifiedName.lastIndexOf(46);
        if (lastDot == -1) {
            this.simpleName = this.qualifiedName;
            this.packageName = null;
        } else {
            this.simpleName = this.qualifiedName.substring(lastDot + 1);
            this.packageName = this.qualifiedName.substring(0, lastDot);
        }
    }

    public TypeReference(String packageName, String simpleName) {
        this.packageName = packageName;
        this.simpleName = simpleName;
        this.qualifiedName = this.packageName == null ? simpleName : String.valueOf(this.packageName) + "." + this.simpleName;
    }

    public TypeReference(Class<?> cl) {
        this(cl.getName());
    }

    public final boolean equals(Object obj) {
        if (obj instanceof TypeReference) {
            return this.getQualifiedName().equals(((TypeReference)obj).getQualifiedName());
        }
        return false;
    }

    public final int hashCode() {
        return this.getQualifiedName().hashCode();
    }

    @Override
    public final int compareTo(TypeReference type) {
        if (type == this) {
            return 0;
        }
        if (type == null) {
            return -1;
        }
        return this.getQualifiedName().compareTo(type.getQualifiedName());
    }

    public final String getQualifiedName() {
        return this.qualifiedName;
    }

    public final String getSimpleName() {
        return this.simpleName;
    }

    public final String getPackage() {
        return this.packageName;
    }

    public TypeReference getBase() {
        return null;
    }

    public ParameterizedTypeReference parameterize(String ... parameters) {
        TypeReference[] tr = new TypeReference[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            tr[i] = new TypeReference(parameters[i]);
            ++i;
        }
        return new ParameterizedTypeReference(this, tr);
    }

    public ParameterizedTypeReference parameterize(TypeReference ... parameters) {
        return new ParameterizedTypeReference(this, parameters);
    }

    public ParameterizedTypeReference parameterize(Class<?> ... parameters) {
        TypeReference[] tr = new TypeReference[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            tr[i] = new TypeReference(parameters[i]);
            ++i;
        }
        return new ParameterizedTypeReference(this, tr);
    }

    public ArrayTypeReference array(int dimensions) {
        return new ArrayTypeReference(this, dimensions);
    }

    public void contributeNecessaryImports(Set<TypeReference> imports) {
        imports.add(this);
    }

    public final String toString() {
        return this.getQualifiedName();
    }
}

