/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.el.t0012;

import java.math.BigDecimal;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.tests.modeling.el.TestExpr;
import org.eclipse.sapphire.tests.modeling.el.t0012.TestModelElementA;
import org.eclipse.sapphire.tests.modeling.el.t0012.TestModelRoot;

public final class TestExpr0012
extends TestExpr {
    private TestExpr0012(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("TestExpr0012");
        suite.addTest((Test)new TestExpr0012("testWithArray"));
        suite.addTest((Test)new TestExpr0012("testWithList"));
        suite.addTest((Test)new TestExpr0012("testWithSet"));
        suite.addTest((Test)new TestExpr0012("testWithModelElementList"));
        return suite;
    }

    public void testWithArray() {
        TestFunctionContext context = new TestFunctionContext(new Object[0]);
        TestExpr0012.testForExpectedValue((FunctionContext)context, "${ Min( Collection ) }", null);
        context = new TestFunctionContext(new Object[]{"1"});
        TestExpr0012.testForExpectedValue((FunctionContext)context, "${ Min( Collection ) }", (Object)new BigDecimal("1"));
        context = new TestFunctionContext(new Object[]{"1", "2", "3.5"});
        TestExpr0012.testForExpectedValue((FunctionContext)context, "${ Min( Collection ) }", (Object)new BigDecimal("1"));
        context = new TestFunctionContext(new Object[]{"1", 2, new BigDecimal("3.5")});
        TestExpr0012.testForExpectedValue((FunctionContext)context, "${ Min( Collection ) }", (Object)new BigDecimal("1"));
    }

    public void testWithList() {
        TestFunctionContext context = new TestFunctionContext(TestExpr0012.list(new Object[0]));
        TestExpr0012.testForExpectedValue((FunctionContext)context, "${ Min( Collection ) }", null);
        context = new TestFunctionContext(TestExpr0012.list("1"));
        TestExpr0012.testForExpectedValue((FunctionContext)context, "${ Min( Collection ) }", (Object)new BigDecimal("1"));
        context = new TestFunctionContext(TestExpr0012.list("1", "2", "3.5"));
        TestExpr0012.testForExpectedValue((FunctionContext)context, "${ Min( Collection ) }", (Object)new BigDecimal("1"));
        context = new TestFunctionContext(TestExpr0012.list("1", 2, new BigDecimal("3.5")));
        TestExpr0012.testForExpectedValue((FunctionContext)context, "${ Min( Collection ) }", (Object)new BigDecimal("1"));
    }

    public void testWithSet() {
        TestFunctionContext context = new TestFunctionContext(TestExpr0012.set(new Object[0]));
        TestExpr0012.testForExpectedValue((FunctionContext)context, "${ Min( Collection ) }", null);
        context = new TestFunctionContext(TestExpr0012.set("1"));
        TestExpr0012.testForExpectedValue((FunctionContext)context, "${ Min( Collection ) }", (Object)new BigDecimal("1"));
        context = new TestFunctionContext(TestExpr0012.set("1", "2", "3.5"));
        TestExpr0012.testForExpectedValue((FunctionContext)context, "${ Min( Collection ) }", (Object)new BigDecimal("1"));
        context = new TestFunctionContext(TestExpr0012.set("1", 2, new BigDecimal("3.5")));
        TestExpr0012.testForExpectedValue((FunctionContext)context, "${ Min( Collection ) }", (Object)new BigDecimal("1"));
    }

    public void testWithModelElementList() {
        TestModelRoot root = (TestModelRoot)TestModelRoot.TYPE.instantiate();
        ModelElementList<TestModelElementA> list = root.getList1();
        ModelElementFunctionContext context = new ModelElementFunctionContext((IModelElement)root);
        TestExpr0012.testForExpectedValue((FunctionContext)context, "${ Min( List1 ) }", null);
        TestExpr0012.testForExpectedValue((FunctionContext)context, "${ Min( List1, 'Value1' ) }", null);
        TestExpr0012.testForExpectedValue((FunctionContext)context, "${ Min( List1, 'Value2' ) }", null);
        TestModelElementA a = (TestModelElementA)list.addNewElement();
        a.setValue1("1");
        a.setValue2(2);
        TestExpr0012.testForExpectedValue((FunctionContext)context, "${ Min( List1 ) }", (Object)new BigDecimal("1"));
        TestExpr0012.testForExpectedValue((FunctionContext)context, "${ Min( List1, 'Value1' ) }", (Object)new BigDecimal("1"));
        TestExpr0012.testForExpectedValue((FunctionContext)context, "${ Min( List1, 'Value2' ) }", (Object)new BigDecimal("2"));
        a = (TestModelElementA)list.addNewElement();
        a.setValue1("2");
        a.setValue2(3);
        a = (TestModelElementA)list.addNewElement();
        a.setValue1("3.5");
        a.setValue2(4);
        TestExpr0012.testForExpectedValue((FunctionContext)context, "${ Min( List1 ) }", (Object)new BigDecimal("1"));
        TestExpr0012.testForExpectedValue((FunctionContext)context, "${ Min( List1, 'Value1' ) }", (Object)new BigDecimal("1"));
        TestExpr0012.testForExpectedValue((FunctionContext)context, "${ Min( List1, 'Value2' ) }", (Object)new BigDecimal("2"));
        TestExpr0012.testForExpectedError((FunctionContext)context, "${ Min( List1, 'abc' ) }", "Property TestModelElementA.abc could not be found.");
        TestExpr0012.testForExpectedError((FunctionContext)context, "${ Min( List1, 'Element1' ) }", "Property TestModelElementA.Element1 is not a value property.");
        TestExpr0012.testForExpectedError((FunctionContext)context, "${ Min( List2 ) }", "Element type TestModelElementB does not contain a value property.");
        FunctionResult result = ExpressionLanguageParser.parse((String)"${ Min( List1, 'Value1' ) }").evaluate((FunctionContext)context);
        TestExpr0012.assertEquals((Object)new BigDecimal("1"), (Object)result.value());
        ((TestModelElementA)list.get(0)).setValue1("2");
        ((TestModelElementA)list.get(1)).setValue1("3.5");
        TestExpr0012.assertEquals((Object)new BigDecimal("2"), (Object)result.value());
        a = (TestModelElementA)list.addNewElement();
        a.setValue1("5.2");
        TestExpr0012.assertEquals((Object)new BigDecimal("2"), (Object)result.value());
    }

    private static final class TestFunctionContext
    extends FunctionContext {
        private final Object collection;

        public TestFunctionContext(Object collection) {
            this.collection = collection;
        }

        public FunctionResult property(Object element, String name) {
            if (element == this && name.equalsIgnoreCase("Collection")) {
                return Literal.create((Object)this.collection).evaluate((FunctionContext)this);
            }
            return super.property(element, name);
        }
    }
}

