/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.util.MutableReference;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.ui.PageBookPart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.def.PageBookExtDef;
import org.eclipse.sapphire.ui.renderers.swt.DefaultListPropertyEditorRenderer;
import org.eclipse.sapphire.ui.swt.SapphireControl;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphireListControlledPageBook
extends PageBookPart {
    private IModelElement element;
    private ListProperty property;

    @Override
    protected void init() {
        super.init();
        String pathString = (String)((PageBookExtDef)this.definition).getControlProperty().getContent();
        String pathStringSubstituted = SapphireListControlledPageBook.substituteParams(pathString, this.params);
        ModelPath path = new ModelPath(pathStringSubstituted);
        this.element = this.getLocalModelElement();
        int i = 0;
        int n = path.length();
        while (i < n) {
            ModelPath.Segment segment = path.segment(i);
            if (segment instanceof ModelPath.ModelRootSegment) {
                this.element = (IModelElement)this.element.root();
            } else if (segment instanceof ModelPath.ParentElementSegment) {
                IModelParticle parent = this.element.parent();
                if (!(parent instanceof IModelElement)) {
                    parent = parent.parent();
                }
                this.element = (IModelElement)parent;
            } else if (segment instanceof ModelPath.PropertySegment) {
                this.property = (ListProperty)this.resolve(this.element, ((ModelPath.PropertySegment)segment).getPropertyName());
                if (i + 1 != n) {
                    throw new RuntimeException(NLS.bind((String)Resources.invalidPath, (Object[])new Object[]{pathString}));
                }
            } else {
                throw new RuntimeException(NLS.bind((String)Resources.invalidPath, (Object[])new Object[]{pathString}));
            }
            ++i;
        }
    }

    @Override
    protected Object parsePageKey(String pageKeyString) {
        ISapphireUiDef rootdef = (ISapphireUiDef)this.definition.nearest(ISapphireUiDef.class);
        Class<?> cl = rootdef.resolveClass(pageKeyString);
        return PageBookPart.ClassBasedKey.create(cl);
    }

    @Override
    public void render(SapphireRenderingContext context) {
        super.render(context);
        Table table = SapphireListControlledPageBook.findControlForProperty((Control)context.getComposite(), this.element, (ModelProperty)this.property, Table.class);
        ISelectionProvider selectionProvider = (ISelectionProvider)table.getData("selection.provider");
        final MutableReference selectedModelElementRef = new MutableReference();
        selectionProvider.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PageBookPart.ClassBasedKey newPageKey;
                IModelElement newModelElement;
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (!sel.isEmpty()) {
                    newModelElement = ((DefaultListPropertyEditorRenderer.TableRow)sel.getFirstElement()).element();
                    newPageKey = PageBookPart.ClassBasedKey.create(newModelElement);
                } else {
                    newModelElement = SapphireListControlledPageBook.this.element;
                    newPageKey = null;
                }
                if (selectedModelElementRef.get() != newModelElement) {
                    selectedModelElementRef.set((Object)newModelElement);
                    Runnable inputChangeOperation = new Runnable(){

                        public void run() {
                            SapphireListControlledPageBook.this.changePage(newModelElement, newPageKey);
                        }
                    };
                    Display.getDefault().syncExec(inputChangeOperation);
                }
            }
        });
        this.changePage(this.element, null);
    }

    private static <T> T findControlForProperty(Control context, IModelElement element, ModelProperty property, Class<T> type) {
        Control root = context;
        while (!(root instanceof SapphireControl)) {
            Composite parent = root.getParent();
            if (parent instanceof Shell) break;
            root = parent;
        }
        return SapphireListControlledPageBook.findControlForPropertyHelper(root, element, property, type);
    }

    private static <T> T findControlForPropertyHelper(Control context, IModelElement element, ModelProperty property, Class<T> type) {
        if (context.getData("element") == element && context.getData("property") == property && type.isAssignableFrom(context.getClass())) {
            return (T)context;
        }
        if (context instanceof Composite) {
            Control[] controlArray = ((Composite)context).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                T control = SapphireListControlledPageBook.findControlForPropertyHelper(child, element, property, type);
                if (control != null) {
                    return control;
                }
                ++n2;
            }
        }
        return null;
    }

    private static final class Resources
    extends NLS {
        public static String invalidPath;

        static {
            Resources.initializeMessages((String)SapphireListControlledPageBook.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

