/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.def.internal;

import java.lang.reflect.Field;
import org.eclipse.sapphire.modeling.ClassLocator;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.ui.def.IDefinitionReference;
import org.eclipse.sapphire.ui.def.IPackageReference;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationDef;
import org.eclipse.sapphire.ui.def.ISapphirePartDef;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphireUiDefMethods {
    public static ISapphirePartDef getPartDef(ISapphireUiDef rootdef, String id, boolean searchImportedDefinitions, Class<?> expectedType) {
        if (id != null) {
            for (ISapphirePartDef def : rootdef.getPartDefs()) {
                if (!id.equals(def.getId().getText())) continue;
                if (expectedType != null && !expectedType.isAssignableFrom(def.getClass())) {
                    String msg = Resources.bind((String)Resources.doesNotImplement, (Object[])new Object[]{id, expectedType.getName()});
                    SapphireUiFrameworkPlugin.logError(msg);
                    return null;
                }
                return def;
            }
            if (searchImportedDefinitions) {
                for (IDefinitionReference ref : rootdef.getImportedDefinitions()) {
                    ISapphirePartDef def;
                    ISapphireUiDef sdef = ref.resolve();
                    if (sdef == null || (def = sdef.getPartDef(id, true, expectedType)) == null) continue;
                    return def;
                }
            }
        }
        return null;
    }

    public static ISapphireDocumentationDef getDocumentationDef(ISapphireUiDef rootdef, String id, boolean searchImportedDefinitions) {
        if (id != null) {
            for (ISapphireDocumentationDef def : rootdef.getDocumentationDefs()) {
                if (!id.equals(def.getId().getText())) continue;
                return def;
            }
            if (searchImportedDefinitions) {
                for (IDefinitionReference ref : rootdef.getImportedDefinitions()) {
                    ISapphireDocumentationDef def;
                    ISapphireUiDef sdef = ref.resolve();
                    if (sdef == null || (def = sdef.getDocumentationDef(id, true)) == null) continue;
                    return def;
                }
            }
        }
        return null;
    }

    public static Class<?> resolveClass(ISapphireUiDef def, String className) {
        ClassLocator locator = (ClassLocator)def.adapt(ClassLocator.class);
        for (IPackageReference packageRef : def.getImportedPackages()) {
            String fullClassName;
            Class cl;
            String packageName = packageRef.getName().getText();
            if (packageName == null || (cl = locator.find(fullClassName = String.valueOf(packageName) + "." + className)) == null) continue;
            return cl;
        }
        return null;
    }

    public static ModelProperty resolveProperty(ISapphireUiDef def, String qualifiedPropertyName) {
        ModelProperty property = null;
        if (qualifiedPropertyName != null) {
            int dot = qualifiedPropertyName.indexOf(46);
            String className = qualifiedPropertyName.substring(0, dot);
            String propertyName = qualifiedPropertyName.substring(dot + 1);
            Class<?> cl = SapphireUiDefMethods.resolveClass(def, className);
            if (cl == null) {
                return null;
            }
            try {
                Field field = cl.getField(propertyName);
                property = (ModelProperty)field.get(null);
            }
            catch (Throwable e) {
                System.err.println("Failed to resolve property: " + qualifiedPropertyName);
                e.printStackTrace();
                return null;
            }
        }
        return property;
    }

    private static final class Resources
    extends NLS {
        public static String doesNotImplement;

        static {
            Resources.initializeMessages((String)SapphireUiDefMethods.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

