/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.renderers.swt;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.services.ValueImageService;
import org.eclipse.sapphire.services.ValueLabelService;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.swt.graphics.Image;

public final class ValueLabelProvider
implements ILabelProvider {
    private final SapphirePropertyEditor part;
    private final ValueProperty property;
    private final LocalizationService localizationService;
    private final ValueLabelService valueLabelService;
    private final ValueImageService valueImageService;

    public ValueLabelProvider(SapphirePropertyEditor part, ValueProperty property) {
        if (part == null) {
            throw new IllegalArgumentException();
        }
        if (property == null) {
            throw new IllegalArgumentException();
        }
        this.part = part;
        this.property = property;
        IModelElement element = this.part.getLocalModelElement();
        this.localizationService = (LocalizationService)this.part.getDefinition().adapt(LocalizationService.class);
        this.valueLabelService = (ValueLabelService)element.service((ModelProperty)this.property, ValueLabelService.class);
        this.valueImageService = (ValueImageService)element.service((ModelProperty)this.property, ValueImageService.class);
    }

    public String getText(Object element) {
        String value = (String)element;
        String label = null;
        try {
            label = this.valueLabelService.provide(value);
        }
        catch (Exception e) {
            LoggingService.log((Exception)e);
        }
        if (label == null) {
            label = value;
        } else if (!label.equals(value)) {
            label = this.localizationService.transform(label, CapitalizationType.FIRST_WORD_ONLY, false);
        }
        return label;
    }

    public Image getImage(Object element) {
        ImageData imageData = this.getImageData(element);
        Image image = null;
        if (imageData != null) {
            image = this.part.getImageCache().getImage(imageData);
        }
        return image;
    }

    public ImageData getImageData(Object element) {
        ImageData imageData = null;
        try {
            imageData = this.valueImageService.provide((String)element);
        }
        catch (Exception e) {
            LoggingService.log((Exception)e);
        }
        if (imageData == null) {
            imageData = this.property.getModelElementType().image();
        }
        return imageData;
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }
}

