/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.sapphire.modeling.LoggingService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiscUtil {
    public static final String EMPTY_STRING = "";

    public static final boolean equal(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 != null && obj2 != null) {
            return obj1.equals(obj2);
        }
        return false;
    }

    public static boolean contains(Object[] array, Object object) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(object)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static <T> boolean containsUsingIdentity(Collection<T> collection, T item) {
        for (T x : collection) {
            if (x != item) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(Object[] array, Object object) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(object)) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    public static String readTextContent(Reader reader) throws IOException {
        int count;
        StringBuffer buf = new StringBuffer();
        char[] chars = new char[8192];
        while ((count = reader.read(chars, 0, chars.length)) > 0) {
            buf.append(chars, 0, count);
        }
        return buf.toString();
    }

    public static String readTextContent(InputStream in) throws IOException {
        return MiscUtil.readTextContent(new InputStreamReader(in));
    }

    /*
     * Loose catch block
     */
    public static String readTextResource(ClassLoader cl, String resourceFullPath) {
        InputStream in = cl.getResourceAsStream(resourceFullPath);
        String string = MiscUtil.readTextContent(in);
        try {
            in.close();
        }
        catch (IOException iOException) {}
        return string;
        catch (IOException e) {
            try {
                LoggingService.log(e);
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
            return EMPTY_STRING;
        }
    }

    public static String readTextResource(Class<?> c, String resourceLocalName) {
        ClassLoader cl = c.getClassLoader();
        String resourcePath = String.valueOf(c.getName().replace('.', '/')) + "." + resourceLocalName;
        return MiscUtil.readTextResource(cl, resourcePath);
    }

    public static final String createStringDigest(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] input = str.getBytes("UTF-8");
            byte[] digest = md.digest(input);
            StringBuilder buf = new StringBuilder();
            int i = 0;
            while (i < digest.length) {
                String hex = Integer.toHexString(0xFF & digest[i]);
                if (hex.length() == 1) {
                    buf.append('0');
                }
                buf.append(hex);
                ++i;
            }
            return buf.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String escapeForXml(String string) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        int n = string.length();
        while (i < n) {
            char ch = string.charAt(i);
            if (ch == '<') {
                result.append("&lt;");
            } else if (ch == '>') {
                result.append("&gt;");
            } else if (ch == '&') {
                result.append("&amp;");
            } else if (ch == '\"') {
                result.append("&quot;");
            } else if (ch == '\'') {
                result.append("&apos;");
            } else {
                result.append(ch);
            }
            ++i;
        }
        return result.toString();
    }

    public static <T> List<T> list(T ... items) {
        return Arrays.asList(items);
    }

    public static <T> Set<T> set(T ... items) {
        return new LinkedHashSet<T>(Arrays.asList(items));
    }
}

