/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.sdk.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.util.Filter;
import org.eclipse.sapphire.sdk.extensibility.ExtensionSummaryExportOp;
import org.eclipse.sapphire.sdk.extensibility.ExtensionSummarySectionColumnDef;
import org.eclipse.sapphire.sdk.extensibility.ExtensionSummarySectionDef;
import org.eclipse.sapphire.sdk.extensibility.FunctionDef;
import org.eclipse.sapphire.sdk.extensibility.SapphireExtensionDef;
import org.eclipse.sapphire.sdk.extensibility.ServiceDef;
import org.eclipse.sapphire.sdk.extensibility.TypeCastDef;
import org.eclipse.sapphire.ui.def.ISapphireActionContext;
import org.eclipse.sapphire.ui.def.ISapphireActionDef;
import org.eclipse.sapphire.ui.def.ISapphireActionHandlerDef;
import org.eclipse.sapphire.ui.def.ISapphireActionHandlerFactoryDef;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtensionSummaryExportOpMethods {
    private static String STYLE;

    public static String execute(ExtensionSummaryExportOp op, List<SapphireExtensionDef> extensions, Filter<IModelElement> filter) {
        ModelElementList<ExtensionSummarySectionDef> sections;
        StringWriter stringWriter = new StringWriter();
        PrintWriter out = new PrintWriter(stringWriter);
        if (((Boolean)op.getCreateFinishedDocument().getContent()).booleanValue()) {
            out.println("<html>");
            out.println();
            out.println("<head>");
            out.println("  <title>" + (String)op.getDocumentTitle().getContent() + "</title>");
            if (((Boolean)op.getEmbedDefaultStyle().getContent()).booleanValue()) {
                out.println(ExtensionSummaryExportOpMethods.style());
            }
            out.println("</head>");
            out.println();
            out.println("<body>");
            String documentBodyTitle = (String)op.getDocumentBodyTitle().getContent();
            if (documentBodyTitle != null) {
                out.println("<h1>" + documentBodyTitle + "</h1>");
            }
        }
        if ((sections = op.getSections()).isEmpty()) {
            ExtensionSummarySectionDef def = (ExtensionSummarySectionDef)sections.addNewElement();
            def.setExtensionType(SapphireExtensionDef.PROP_SERVICES.getName());
            def = (ExtensionSummarySectionDef)sections.addNewElement();
            def.setExtensionType(SapphireExtensionDef.PROP_FUNCTIONS.getName());
            def = (ExtensionSummarySectionDef)sections.addNewElement();
            def.setExtensionType(SapphireExtensionDef.PROP_TYPE_CASTS.getName());
            def = (ExtensionSummarySectionDef)sections.addNewElement();
            def.setExtensionType(SapphireExtensionDef.PROP_ACTIONS.getName());
            def = (ExtensionSummarySectionDef)sections.addNewElement();
            def.setExtensionType(SapphireExtensionDef.PROP_ACTION_HANDLERS.getName());
            def = (ExtensionSummarySectionDef)sections.addNewElement();
            def.setExtensionType(SapphireExtensionDef.PROP_ACTION_HANDLER_FACTORIES.getName());
        }
        for (ExtensionSummarySectionDef def : sections) {
            SectionWriter sectionWriter;
            String extensionType = def.getExtensionType().getText();
            if (extensionType.equals(SapphireExtensionDef.PROP_SERVICES.getName())) {
                sectionWriter = new ServicesSectionWriter(out, extensions, filter, def);
            } else if (extensionType.endsWith(SapphireExtensionDef.PROP_FUNCTIONS.getName())) {
                sectionWriter = new FunctionsSectionWriter(out, extensions, filter, def);
            } else if (extensionType.endsWith(SapphireExtensionDef.PROP_TYPE_CASTS.getName())) {
                sectionWriter = new TypeCastsSectionWriter(out, extensions, filter, def);
            } else if (extensionType.endsWith(SapphireExtensionDef.PROP_ACTIONS.getName())) {
                sectionWriter = new ActionsSectionWriter(out, extensions, filter, def);
            } else if (extensionType.endsWith(SapphireExtensionDef.PROP_ACTION_HANDLERS.getName())) {
                sectionWriter = new ActionHandlersSectionWriter(out, extensions, filter, def);
            } else if (extensionType.endsWith(SapphireExtensionDef.PROP_ACTION_HANDLER_FACTORIES.getName())) {
                sectionWriter = new ActionHandlerFactoriesSectionWriter(out, extensions, filter, def);
            } else {
                throw new IllegalStateException();
            }
            sectionWriter.write();
        }
        if (((Boolean)op.getCreateFinishedDocument().getContent()).booleanValue()) {
            out.println("<br/><br/>");
            out.println();
            out.println("</body>");
            out.println();
            out.println("</head>");
        }
        out.flush();
        return stringWriter.getBuffer().toString();
    }

    private static String style() {
        if (STYLE == null) {
            StringBuilder buf;
            block16: {
                buf = new StringBuilder();
                buf.append("<style type=\"text/css\">\n");
                try {
                    URL url;
                    Bundle bundle = Platform.getBundle((String)"org.eclipse.sapphire.doc");
                    if (bundle == null || (url = bundle.getEntry("html/style.css")) == null) break block16;
                    InputStream in = url.openStream();
                    try {
                        InputStreamReader reader = new InputStreamReader(in);
                        try {
                            char[] chars = new char[1024];
                            int count = reader.read(chars);
                            while (count != -1) {
                                buf.append(chars, 0, count);
                                count = reader.read(chars);
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                        try {
                            ((Reader)reader).close();
                        }
                        catch (IOException iOException) {}
                    }
                    catch (Throwable throwable) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                catch (Exception e) {
                    LoggingService.log((Exception)e);
                }
            }
            buf.append("\n</style>");
            STYLE = buf.toString();
        }
        return STYLE;
    }

    private static String normalize(String text) {
        return ExtensionSummaryExportOpMethods.normalize(text, "");
    }

    private static String normalize(String text, String textForNull) {
        return text == null || text.trim().length() == 0 ? textForNull : text;
    }

    private static int comp(String x, String y) {
        if (x == y) {
            return 0;
        }
        if (x == null) {
            return -1;
        }
        if (y == null) {
            return 1;
        }
        return x.compareToIgnoreCase(y);
    }

    private static String formatClassName(String className) {
        int lastDotPlusOne;
        StringBuilder buf = new StringBuilder();
        int lastDot = className.lastIndexOf(46);
        if (lastDot != -1) {
            buf.append("<font color=\"#888888\">");
            buf.append(className.substring(0, lastDot + 1));
            buf.append("</font>");
        }
        if ((lastDotPlusOne = lastDot + 1) < className.length()) {
            buf.append(className.substring(lastDotPlusOne));
        }
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ActionHandlerFactoriesSectionWriter
    extends SectionWriter {
        public ActionHandlerFactoriesSectionWriter(PrintWriter out, List<SapphireExtensionDef> extensions, Filter<IModelElement> filter, ExtensionSummarySectionDef def) {
            super(out, extensions, filter, def);
        }

        @Override
        protected void sort(List<IModelElement> extElements) {
            Collections.sort(extElements, new Comparator<IModelElement>(){

                @Override
                public int compare(IModelElement a, IModelElement b) {
                    ISapphireActionHandlerFactoryDef x = (ISapphireActionHandlerFactoryDef)a;
                    ISapphireActionHandlerFactoryDef y = (ISapphireActionHandlerFactoryDef)b;
                    int res = ExtensionSummaryExportOpMethods.comp((String)x.getAction().getContent(), (String)y.getAction().getContent());
                    if (res == 0) {
                        res = ExtensionSummaryExportOpMethods.comp(x.getImplClass().getText(), y.getImplClass().getText());
                    }
                    return res;
                }
            });
        }

        @Override
        protected List<ModelProperty> getDefaultColumns() {
            ArrayList<ModelProperty> columns = new ArrayList<ModelProperty>();
            columns.add((ModelProperty)ISapphireActionHandlerFactoryDef.PROP_ACTION);
            columns.add((ModelProperty)ISapphireActionHandlerFactoryDef.PROP_DESCRIPTION);
            return columns;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ActionHandlersSectionWriter
    extends SectionWriter {
        public ActionHandlersSectionWriter(PrintWriter out, List<SapphireExtensionDef> extensions, Filter<IModelElement> filter, ExtensionSummarySectionDef def) {
            super(out, extensions, filter, def);
        }

        @Override
        protected void sort(List<IModelElement> extElements) {
            Collections.sort(extElements, new Comparator<IModelElement>(){

                @Override
                public int compare(IModelElement a, IModelElement b) {
                    ISapphireActionHandlerDef x = (ISapphireActionHandlerDef)a;
                    ISapphireActionHandlerDef y = (ISapphireActionHandlerDef)b;
                    int res = ExtensionSummaryExportOpMethods.comp((String)x.getAction().getContent(), (String)y.getAction().getContent());
                    if (res == 0) {
                        res = ExtensionSummaryExportOpMethods.comp((String)x.getId().getContent(), (String)y.getId().getContent());
                    }
                    return res;
                }
            });
        }

        @Override
        protected List<ModelProperty> getDefaultColumns() {
            ArrayList<ModelProperty> columns = new ArrayList<ModelProperty>();
            columns.add((ModelProperty)ISapphireActionHandlerDef.PROP_ACTION);
            columns.add((ModelProperty)ISapphireActionHandlerDef.PROP_ID);
            columns.add((ModelProperty)ISapphireActionHandlerDef.PROP_DESCRIPTION);
            return columns;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ActionsSectionWriter
    extends SectionWriter {
        public ActionsSectionWriter(PrintWriter out, List<SapphireExtensionDef> extensions, Filter<IModelElement> filter, ExtensionSummarySectionDef def) {
            super(out, extensions, filter, def);
        }

        @Override
        protected void sort(List<IModelElement> extElements) {
            Collections.sort(extElements, new Comparator<IModelElement>(){

                @Override
                public int compare(IModelElement a, IModelElement b) {
                    ISapphireActionDef x = (ISapphireActionDef)a;
                    ISapphireActionDef y = (ISapphireActionDef)b;
                    return ExtensionSummaryExportOpMethods.comp((String)x.getId().getContent(), (String)y.getId().getContent());
                }
            });
        }

        @Override
        protected List<ModelProperty> getDefaultColumns() {
            ArrayList<ModelProperty> columns = new ArrayList<ModelProperty>();
            columns.add((ModelProperty)ISapphireActionDef.PROP_ID);
            columns.add((ModelProperty)ISapphireActionDef.PROP_DESCRIPTION);
            columns.add((ModelProperty)ISapphireActionDef.PROP_KEY_BINDING);
            columns.add((ModelProperty)ISapphireActionDef.PROP_CONTEXTS);
            return columns;
        }

        @Override
        protected String getCellText(IModelElement element, ModelProperty property) {
            if (property == ISapphireActionDef.PROP_CONTEXTS) {
                StringBuilder contexts = new StringBuilder();
                for (ISapphireActionContext context : ((ISapphireActionDef)element).getContexts()) {
                    if (contexts.length() > 0) {
                        contexts.append("<br/>");
                    }
                    contexts.append(ExtensionSummaryExportOpMethods.normalize(context.getContext().getText()));
                }
                return contexts.toString();
            }
            return super.getCellText(element, property);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FunctionsSectionWriter
    extends SectionWriter {
        public FunctionsSectionWriter(PrintWriter out, List<SapphireExtensionDef> extensions, Filter<IModelElement> filter, ExtensionSummarySectionDef def) {
            super(out, extensions, filter, def);
        }

        @Override
        protected void sort(List<IModelElement> extElements) {
            Collections.sort(extElements, new Comparator<IModelElement>(){

                @Override
                public int compare(IModelElement a, IModelElement b) {
                    FunctionDef x = (FunctionDef)a;
                    FunctionDef y = (FunctionDef)b;
                    return ExtensionSummaryExportOpMethods.comp((String)x.getName().getContent(), (String)y.getName().getContent());
                }
            });
        }

        @Override
        protected List<ModelProperty> getDefaultColumns() {
            ArrayList<ModelProperty> columns = new ArrayList<ModelProperty>();
            columns.add((ModelProperty)FunctionDef.PROP_NAME);
            columns.add((ModelProperty)FunctionDef.PROP_DESCRIPTION);
            columns.add((ModelProperty)FunctionDef.PROP_IMPL_CLASS);
            return columns;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class SectionWriter {
        private final PrintWriter out;
        private final List<SapphireExtensionDef> extensions;
        private final Filter<IModelElement> filter;
        private final ExtensionSummarySectionDef def;

        public SectionWriter(PrintWriter out, List<SapphireExtensionDef> extensions, Filter<IModelElement> filter, ExtensionSummarySectionDef def) {
            this.out = out;
            this.extensions = extensions;
            this.filter = filter;
            this.def = def;
        }

        public final void write() {
            ListProperty extTypeListProperty = (ListProperty)SapphireExtensionDef.TYPE.getProperty(this.def.getExtensionType().getText());
            ModelElementType extType = extTypeListProperty.getType();
            ArrayList<IModelElement> extElements = new ArrayList<IModelElement>();
            if (this.filter == null) {
                for (SapphireExtensionDef extension : this.extensions) {
                    extElements.addAll((Collection<IModelElement>)extension.read(extTypeListProperty));
                }
            } else {
                for (SapphireExtensionDef extension : this.extensions) {
                    for (Object extElement : extension.read(extTypeListProperty)) {
                        if (!this.filter.check(extElement)) continue;
                        extElements.add((IModelElement)extElement);
                    }
                }
            }
            if (!extElements.isEmpty()) {
                this.sort(extElements);
                if (((Boolean)this.def.getIncludeSectionHeader().getContent()).booleanValue()) {
                    ExtensionSummaryExportOp op = (ExtensionSummaryExportOp)this.def.nearest(ExtensionSummaryExportOp.class);
                    String sectionHeaderLevel = (Boolean)op.getCreateFinishedDocument().getContent() == false || op.getDocumentBodyTitle().getContent() == null ? "h1" : "h2";
                    this.out.println();
                    this.out.print("<a name=\"");
                    this.out.print(extTypeListProperty.getName());
                    this.out.print("\"><");
                    this.out.print(sectionHeaderLevel);
                    this.out.print('>');
                    this.out.print(extTypeListProperty.getLabel(true, CapitalizationType.TITLE_STYLE, false));
                    this.out.print("</");
                    this.out.print(sectionHeaderLevel);
                    this.out.print("></a>");
                    this.out.println();
                }
                ArrayList<ModelProperty> columns = new ArrayList<ModelProperty>();
                for (ExtensionSummarySectionColumnDef cdef : this.def.getColumns()) {
                    ModelProperty cprop = extType.getProperty(cdef.getName().getText());
                    if (cprop == null) continue;
                    columns.add(cprop);
                }
                if (columns.isEmpty()) {
                    columns.addAll(this.getDefaultColumns());
                }
                Iterator itr = columns.iterator();
                while (itr.hasNext()) {
                    ModelProperty cprop = (ModelProperty)itr.next();
                    boolean empty = true;
                    if (cprop instanceof ValueProperty) {
                        ValueProperty cvprop = (ValueProperty)cprop;
                        for (IModelElement element : extElements) {
                            if (element.read(cvprop).getText() == null) continue;
                            empty = false;
                            break;
                        }
                    } else if (cprop instanceof ListProperty) {
                        ListProperty clprop = (ListProperty)cprop;
                        for (IModelElement element : extElements) {
                            if (element.read(clprop).isEmpty()) continue;
                            empty = false;
                            break;
                        }
                    } else {
                        empty = false;
                    }
                    if (!empty) continue;
                    itr.remove();
                }
                this.out.println();
                this.out.println("<table>");
                this.out.println("  <tr>");
                for (ModelProperty column : columns) {
                    this.out.print("    <th>");
                    this.out.print(column.getLabel(true, CapitalizationType.TITLE_STYLE, true));
                    this.out.print("</th>");
                    this.out.println();
                }
                this.out.println("  </tr>");
                for (IModelElement extElement : extElements) {
                    this.out.println("  <tr>");
                    for (ModelProperty column : columns) {
                        String text = this.getCellText(extElement, column);
                        this.out.print("    <td>");
                        this.out.print(ExtensionSummaryExportOpMethods.normalize(text, "&nbsp;"));
                        this.out.print("</td>");
                        this.out.println();
                    }
                    this.out.println("  </tr>");
                }
                this.out.println("</table>");
            }
        }

        protected void sort(List<IModelElement> extElements) {
        }

        protected abstract List<ModelProperty> getDefaultColumns();

        protected String getCellText(IModelElement element, ModelProperty property) {
            String text = element.read((ValueProperty)property).getText();
            Reference ref = (Reference)property.getAnnotation(Reference.class);
            if (ref != null && ref.target() == Class.class) {
                text = ExtensionSummaryExportOpMethods.formatClassName(text);
            }
            if (text == null) {
                text = "";
            }
            return text;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ServicesSectionWriter
    extends SectionWriter {
        public ServicesSectionWriter(PrintWriter out, List<SapphireExtensionDef> extensions, Filter<IModelElement> filter, ExtensionSummarySectionDef def) {
            super(out, extensions, filter, def);
        }

        @Override
        protected List<ModelProperty> getDefaultColumns() {
            ArrayList<ModelProperty> columns = new ArrayList<ModelProperty>();
            columns.add((ModelProperty)ServiceDef.PROP_TYPE);
            columns.add((ModelProperty)ServiceDef.PROP_FACTORY);
            columns.add((ModelProperty)ServiceDef.PROP_CONTEXT);
            return columns;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TypeCastsSectionWriter
    extends SectionWriter {
        public TypeCastsSectionWriter(PrintWriter out, List<SapphireExtensionDef> extensions, Filter<IModelElement> filter, ExtensionSummarySectionDef def) {
            super(out, extensions, filter, def);
        }

        @Override
        protected void sort(List<IModelElement> extElements) {
            Collections.sort(extElements, new Comparator<IModelElement>(){

                @Override
                public int compare(IModelElement a, IModelElement b) {
                    TypeCastDef x = (TypeCastDef)a;
                    TypeCastDef y = (TypeCastDef)b;
                    return ExtensionSummaryExportOpMethods.comp(x.getTargetType().getText(), y.getTargetType().getText());
                }
            });
        }

        @Override
        protected List<ModelProperty> getDefaultColumns() {
            ArrayList<ModelProperty> columns = new ArrayList<ModelProperty>();
            columns.add((ModelProperty)TypeCastDef.PROP_SOURCE_TYPE);
            columns.add((ModelProperty)TypeCastDef.PROP_TARGET_TYPE);
            columns.add((ModelProperty)TypeCastDef.PROP_DESCRIPTION);
            columns.add((ModelProperty)TypeCastDef.PROP_IMPLEMENTATION);
            return columns;
        }
    }
}

