/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml.internal;

import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.modeling.xml.RootElementController;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.annotations.XmlDocumentType;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public final class DocumentTypeRootElementController
extends RootElementController {
    private String rootElementName;
    private String publicId;
    private String systemId;

    public DocumentTypeRootElementController(String rootElementName) {
        this.rootElementName = rootElementName;
    }

    public void init(XmlResource resource) {
        super.init(resource);
        XmlDocumentType doctypeAnnotation = (XmlDocumentType)resource.root().element().getModelElementType().getAnnotation(XmlDocumentType.class);
        if (doctypeAnnotation != null) {
            this.systemId = DocumentTypeRootElementController.normalizeToNull(doctypeAnnotation.systemId());
            if (this.systemId == null) {
                throw new IllegalStateException();
            }
            this.publicId = DocumentTypeRootElementController.normalizeToNull(doctypeAnnotation.publicId());
        }
    }

    protected void createRootElement(Document document) {
        Element root = document.createElementNS(null, this.rootElementName);
        DocumentType doctype = null;
        doctype = this.publicId != null ? document.getImplementation().createDocumentType(this.rootElementName, this.publicId, this.systemId) : document.getImplementation().createDocumentType(this.rootElementName, null, this.systemId);
        if (doctype != null) {
            document.appendChild(doctype);
            document.insertBefore(root, doctype);
        }
        document.appendChild(root);
    }

    public void createRootElement() {
        Document document = this.resource().root().getDomDocument();
        this.createRootElement(document);
    }

    public boolean checkRootElement() {
        DocumentType documentType;
        Document document = this.resource().root().getDomDocument();
        Element root = document.getDocumentElement();
        return MiscUtil.equal((Object)root.getLocalName(), (Object)this.rootElementName) && (documentType = document.getDoctype()) != null && this.systemId.equals(documentType.getSystemId()) && MiscUtil.equal((Object)this.publicId, (Object)DocumentTypeRootElementController.normalizeToNull(documentType.getPublicId()));
    }

    private static String normalizeToNull(String value) {
        String result = value;
        if (value != null && value.length() == 0) {
            result = null;
        }
        return result;
    }
}

