/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.Collections;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.util.MutableReference;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionSystemPart;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireActionLinkDef;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.internal.formtext.SapphireFormText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphireActionLink
extends SapphirePart {
    @Override
    public void render(final SapphireRenderingContext context) {
        Label imageLabel;
        ImageDescriptor imageDescriptor;
        ISapphireActionLinkDef def = (ISapphireActionLinkDef)this.definition;
        String actionId = (String)def.getActionId().getContent();
        final String actionHandlerId = (String)def.getActionHandlerId().getContent();
        final SapphireAction action = this.getAction(actionId);
        String labelText = def.getLabel().getLocalizedText(CapitalizationType.FIRST_WORD_ONLY, false);
        boolean showImage = (Boolean)def.getShowImage().getContent();
        Image image = null;
        if (showImage && action != null && (imageDescriptor = action.getImage(16)) != null) {
            image = this.getImageCache().getImage(imageDescriptor);
        }
        Composite composite = new Composite(context.getComposite(), 0);
        composite.setLayout((Layout)GridLayoutUtil.glayout(image == null ? 1 : 2, 0, 0));
        composite.setLayoutData((Object)GridLayoutUtil.gdhindent(GridLayoutUtil.gdhspan(GridLayoutUtil.gd(), 2), 8));
        if (image != null) {
            imageLabel = new Label(composite, 0);
            imageLabel.setImage(image);
            imageLabel.setLayoutData((Object)GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 0x1000000));
        } else {
            imageLabel = null;
        }
        final SapphireFormText text = new SapphireFormText(composite, 0);
        text.setLayoutData(GridLayoutUtil.gdvalign(GridLayoutUtil.gdhfill(), 0x1000000));
        context.adapt((Control)text);
        StringBuilder buf = new StringBuilder();
        buf.append("<form><p vspace=\"false\"><a href=\"action\" nowrap=\"true\">");
        buf.append(labelText);
        buf.append("</a></p></form>");
        text.setText(buf.toString(), true, false);
        if (action != null) {
            final MutableReference actionHandlerRef = new MutableReference();
            final MutableReference actionHandlerListenerRef = new MutableReference();
            final Runnable refreshEnablementStateOp = new Runnable(){

                public void run() {
                    boolean enabled;
                    SapphireActionHandler actionHandler = (SapphireActionHandler)actionHandlerRef.get();
                    boolean bl = enabled = actionHandler != null && actionHandler.isEnabled();
                    if (imageLabel != null) {
                        imageLabel.setEnabled(enabled);
                    }
                    text.setEnabled(enabled);
                }
            };
            final Runnable resolveHandlerOp = new Runnable(){

                public void run() {
                    Listener actionHandlerListener;
                    SapphireActionHandler actionHandler = (SapphireActionHandler)actionHandlerRef.get();
                    if (actionHandler != null) {
                        actionHandlerListener = (Listener)actionHandlerListenerRef.get();
                        if (actionHandlerListener != null) {
                            actionHandler.detach(actionHandlerListener);
                        }
                        actionHandler = null;
                    }
                    if (actionHandlerId == null) {
                        actionHandler = action.getFirstActiveHandler();
                    } else {
                        for (SapphireActionHandler h : action.getActiveHandlers()) {
                            if (!h.getId().equalsIgnoreCase(actionHandlerId)) continue;
                            actionHandler = h;
                            break;
                        }
                    }
                    actionHandlerRef.set((Object)actionHandler);
                    if (actionHandler != null) {
                        actionHandlerListener = (Listener)actionHandlerListenerRef.get();
                        if (actionHandlerListener == null) {
                            actionHandlerListener = new Listener(){

                                public void handle(Event event) {
                                    if (event instanceof SapphireActionSystemPart.EnablementChangedEvent) {
                                        refreshEnablementStateOp.run();
                                    }
                                }
                            };
                            actionHandlerListenerRef.set((Object)actionHandlerListener);
                        }
                        actionHandler.attach(actionHandlerListener);
                    }
                    refreshEnablementStateOp.run();
                }
            };
            resolveHandlerOp.run();
            final Listener actionListener = new Listener(){

                public void handle(Event event) {
                    if (event instanceof SapphireAction.HandlersChangedEvent) {
                        resolveHandlerOp.run();
                    }
                }
            };
            action.attach(actionListener);
            text.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    action.detach(actionListener);
                    SapphireActionHandler actionHandler = (SapphireActionHandler)actionHandlerRef.get();
                    Listener actionHandlerListener = (Listener)actionHandlerListenerRef.get();
                    if (actionHandler != null && actionHandlerListener != null) {
                        actionHandler.detach(actionHandlerListener);
                    }
                }
            });
            text.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent event) {
                    SapphireActionHandler handler = (SapphireActionHandler)actionHandlerRef.get();
                    if (handler != null) {
                        handler.execute(context);
                    }
                }
            });
        } else {
            if (imageLabel != null) {
                imageLabel.setEnabled(false);
            }
            text.setEnabled(false);
        }
    }

    @Override
    public Set<String> getActionContexts() {
        return Collections.singleton("Sapphire.ActionLink");
    }
}

