/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.lang.reflect.Field;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.ui.PageBookPart;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.def.PageBookExtDef;

public final class SapphireEnumControlledPageBook
extends PageBookPart {
    private IModelElement element;
    private ValueProperty property;
    private ModelPropertyListener listener;

    protected void init() {
        super.init();
        String pathString = (String)((PageBookExtDef)this.definition).getControlProperty().getContent();
        String pathStringSubstituted = SapphireEnumControlledPageBook.substituteParams(pathString, this.params);
        ModelPath path = new ModelPath(pathStringSubstituted);
        this.element = this.getLocalModelElement();
        int i = 0;
        int n = path.length();
        while (i < n) {
            ModelPath.Segment segment = path.segment(i);
            if (segment instanceof ModelPath.ModelRootSegment) {
                this.element = (IModelElement)this.element.root();
            } else if (segment instanceof ModelPath.ParentElementSegment) {
                IModelParticle parent = this.element.parent();
                if (!(parent instanceof IModelElement)) {
                    parent = parent.parent();
                }
                this.element = (IModelElement)parent;
            } else if (segment instanceof ModelPath.PropertySegment) {
                this.property = (ValueProperty)this.resolve(this.element, ((ModelPath.PropertySegment)segment).getPropertyName());
                if (i + 1 != n) {
                    throw new RuntimeException(NLS.bind((String)Resources.invalidPath, (Object[])new Object[]{pathStringSubstituted}));
                }
            } else {
                throw new RuntimeException(NLS.bind((String)Resources.invalidPath, (Object[])new Object[]{pathStringSubstituted}));
            }
            ++i;
        }
        this.listener = new ModelPropertyListener(){

            public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                if (event.getProperty() == SapphireEnumControlledPageBook.this.property) {
                    SapphireEnumControlledPageBook.this.updateCurrentPage();
                }
            }
        };
        this.element.addListener(this.listener, this.property.getName());
        this.setExposePageValidationState(true);
        this.updateCurrentPage();
    }

    protected Object parsePageKey(String panelKeyString) {
        Field field;
        int lastDot = panelKeyString.lastIndexOf(46);
        String className = panelKeyString.substring(0, lastDot);
        String enumItemName = panelKeyString.substring(lastDot + 1);
        ISapphireUiDef rootdef = (ISapphireUiDef)this.definition.nearest(ISapphireUiDef.class);
        Class<?> classObject = rootdef.resolveClass(className);
        try {
            field = classObject.getField(enumItemName);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        try {
            return field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateCurrentPage() {
        Value newEnumItemValue = this.element.read(this.property);
        Enum newEnumItem = (Enum)newEnumItemValue.getContent(true);
        this.changePage(this.element, newEnumItem);
    }

    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            this.element.removeListener(this.listener, this.property.getName());
        }
    }

    private static final class Resources
    extends NLS {
        public static String invalidPath;

        static {
            Resources.initializeMessages((String)SapphireEnumControlledPageBook.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

