/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.help.IContext;
import org.eclipse.help.IContext2;
import org.eclipse.help.IHelpResource;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.util.internal.DocumentationUtil;
import org.eclipse.sapphire.services.DocumentationService;

public final class SapphireHelpContext
implements IContext,
IContext2 {
    private final String title;
    private final String content;
    private final List<IHelpResource> topics;

    public SapphireHelpContext(IModelElement element, ModelProperty property) {
        String title = null;
        StringBuilder content = new StringBuilder();
        ArrayList topics = new ArrayList();
        DocumentationService propDocService = (DocumentationService)element.service(property, DocumentationService.class);
        DocumentationService elDocService = (DocumentationService)element.service(DocumentationService.class);
        content.append("[br/]");
        if (propDocService == null) {
            if (elDocService != null) {
                title = element.getModelElementType().getLabel(true, CapitalizationType.TITLE_STYLE, false);
                content.append(elDocService.content());
                topics.addAll(elDocService.topics());
            }
        } else {
            title = property.getLabel(true, CapitalizationType.TITLE_STYLE, false);
            content.append(propDocService.content());
            topics.addAll(propDocService.topics());
            if (elDocService != null) {
                content.append("[pbr/][b]");
                content.append(element.getModelElementType().getLabel(true, CapitalizationType.TITLE_STYLE, false));
                content.append("[/b][pbr/]");
                content.append(elDocService.content());
                topics.addAll(elDocService.topics());
            }
        }
        content.append("[pbr/]");
        this.title = title;
        this.content = DocumentationUtil.decodeDocumentationTags((String)content.toString());
        this.topics = new ArrayList<IHelpResource>(topics.size());
        for (final DocumentationService.Topic topic : topics) {
            IHelpResource hres = new IHelpResource(){

                public String getLabel() {
                    return topic.label();
                }

                public String getHref() {
                    return topic.url();
                }
            };
            this.topics.add(hres);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getText() {
        return this.content;
    }

    public String getStyledText() {
        return null;
    }

    public String getCategory(IHelpResource topic) {
        return null;
    }

    public IHelpResource[] getRelatedTopics() {
        return this.topics.toArray(new IHelpResource[this.topics.size()]);
    }
}

