/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.renderer;

import java.util.List;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.localization.LabelTransformer;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionSystemPart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.SapphireActionType;
import org.eclipse.sapphire.ui.swt.renderer.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.swt.renderer.SapphireHotSpotsActionPresentation;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public final class SapphireToolBarActionPresentation
extends SapphireHotSpotsActionPresentation {
    private ToolBar toolbar;

    public SapphireToolBarActionPresentation(SapphireActionPresentationManager manager) {
        super(manager);
    }

    public SapphireToolBarActionPresentation(ISapphirePart part, Shell shell, SapphireActionGroup actions) {
        this(new SapphireActionPresentationManager(new SapphireRenderingContext(part, shell), actions));
    }

    public ToolBar getToolBar() {
        return this.toolbar;
    }

    public void setToolBar(ToolBar toolbar) {
        this.toolbar = toolbar;
    }

    public void render() {
        final SapphireRenderingContext context = this.getManager().getContext();
        boolean first = true;
        String lastGroup = null;
        for (final SapphireAction action : this.getActions()) {
            SelectionAdapter toolItemListener;
            ToolItem toolItem;
            String group = action.getGroup();
            if (!first && !MiscUtil.equal(lastGroup, (Object)group)) {
                new ToolItem(this.toolbar, 2);
            }
            first = false;
            lastGroup = group;
            if (action.getType() == SapphireActionType.PUSH) {
                toolItem = new ToolItem(this.toolbar, 8);
                this.registerHotSpot(action, new ToolItemHotSpot(toolItem));
                toolItemListener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        List<SapphireActionHandler> handlers = action.getActiveHandlers();
                        if (handlers.size() == 1) {
                            handlers.get(0).execute(context);
                        } else {
                            SapphireToolBarActionPresentation.this.displayActionHandlerChoice(action);
                        }
                    }
                };
            } else if (action.getType() == SapphireActionType.TOGGLE) {
                toolItem = new ToolItem(this.toolbar, 32);
                toolItemListener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        action.getActiveHandlers().get(0).execute(context);
                    }
                };
            } else {
                throw new IllegalStateException();
            }
            final String hint = action.getRenderingHint("style", "image");
            if ("image".equals(hint) || "image+text".equals(hint)) {
                toolItem.setImage(context.getImageCache().getImage(action.getImage(16)));
            }
            toolItem.setData((Object)action);
            toolItem.addSelectionListener((SelectionListener)toolItemListener);
            final Runnable updateActionLabelOp = new Runnable(){

                public void run() {
                    if (!toolItem.isDisposed()) {
                        if ("image+text".equals(hint) || "text".equals(hint)) {
                            toolItem.setText(LabelTransformer.transform((String)action.getLabel(), (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)true));
                        }
                        toolItem.setToolTipText(LabelTransformer.transform((String)action.getLabel(), (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)false));
                    }
                }
            };
            final Runnable updateActionEnablementStateOp = new Runnable(){

                public void run() {
                    if (Display.getCurrent() == null) {
                        Display.getDefault().asyncExec((Runnable)this);
                        return;
                    }
                    if (!toolItem.isDisposed()) {
                        toolItem.setEnabled(action.isEnabled());
                    }
                }
            };
            final Runnable updateActionCheckedStateOp = new Runnable(){

                public void run() {
                    if (Display.getCurrent() == null) {
                        Display.getDefault().asyncExec((Runnable)this);
                        return;
                    }
                    if (!toolItem.isDisposed()) {
                        toolItem.setSelection(action.isChecked());
                    }
                }
            };
            action.attach(new Listener(){

                public void handle(Event event) {
                    if (event instanceof SapphireActionSystemPart.LabelChangedEvent) {
                        updateActionLabelOp.run();
                    }
                    if (event instanceof SapphireActionSystemPart.EnablementChangedEvent) {
                        updateActionEnablementStateOp.run();
                    } else if (event instanceof SapphireActionSystemPart.CheckedStateChangedEvent) {
                        updateActionCheckedStateOp.run();
                    }
                }
            });
            updateActionLabelOp.run();
            updateActionEnablementStateOp.run();
            updateActionCheckedStateOp.run();
        }
        this.toolbar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                int childId = event.childID;
                if (childId == -1) {
                    event.result = SapphireToolBarActionPresentation.this.getManager().getLabel();
                } else if (childId < SapphireToolBarActionPresentation.this.toolbar.getItemCount()) {
                    ToolItem item = SapphireToolBarActionPresentation.this.toolbar.getItem(childId);
                    SapphireAction action = (SapphireAction)item.getData();
                    event.result = LabelTransformer.transform((String)action.getLabel(), (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)false);
                }
            }
        });
    }

    private static final class ToolItemHotSpot
    extends SapphireHotSpotsActionPresentation.HotSpot {
        private final ToolItem item;

        public ToolItemHotSpot(ToolItem item) {
            this.item = item;
        }

        public Rectangle getBounds() {
            return this.toDisplay((Control)this.item.getParent(), this.item.getBounds());
        }
    }
}

