/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import java.util.Collections;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.modeling.xml.RootElementController;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchema;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchemasCache;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardRootElementController
extends RootElementController {
    private final RootElementInfo info;

    public StandardRootElementController() {
        this.info = null;
    }

    public StandardRootElementController(String elementName) {
        this(null, null, elementName, Collections.emptyMap());
    }

    public StandardRootElementController(QName elementName) {
        this(elementName.getNamespaceURI(), elementName.getPrefix(), elementName.getLocalPart(), Collections.emptyMap());
    }

    public StandardRootElementController(String namespace, String defaultPrefix, String elementName, String schemaLocation) {
        Map<Object, Object> schemas = schemaLocation == null || schemaLocation.length() == 0 ? Collections.emptyMap() : Collections.singletonMap(namespace, schemaLocation);
        this.info = new RootElementInfo(namespace, defaultPrefix, elementName, schemas);
    }

    public StandardRootElementController(String namespace, String defaultPrefix, String elementName, Map<String, String> schemas) {
        this.info = new RootElementInfo(namespace, defaultPrefix, elementName, schemas);
    }

    protected RootElementInfo getRootElementInfo() {
        return this.info;
    }

    @Override
    public void createRootElement() {
        this.createRootElement(this.resource().root().getDomDocument(), this.getRootElementInfo());
    }

    protected void createRootElement(Document document, RootElementInfo rinfo) {
        Element root;
        if (rinfo.namespace == null) {
            root = document.createElementNS(null, rinfo.elementName);
        } else {
            if (rinfo.defaultPrefix == null) {
                root = document.createElementNS(rinfo.namespace, rinfo.elementName);
                root.setAttribute("xmlns", rinfo.namespace);
            } else {
                root = document.createElementNS(rinfo.namespace, String.valueOf(rinfo.defaultPrefix) + ":" + rinfo.elementName);
                root.setAttribute("xmlns:" + rinfo.defaultPrefix, rinfo.namespace);
            }
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            StringBuilder buf = new StringBuilder();
            for (String schemaLocation : rinfo.schemas.values()) {
                XmlDocumentSchema xmlDocumentSchema = XmlDocumentSchemasCache.getSchema(schemaLocation);
                if (xmlDocumentSchema == null) continue;
                for (Map.Entry<String, String> entry : xmlDocumentSchema.getSchemaLocations().entrySet()) {
                    if (buf.length() > 0) {
                        buf.append(' ');
                    }
                    buf.append(entry.getKey());
                    buf.append(' ');
                    buf.append(entry.getValue());
                }
            }
            if (buf.length() > 0) {
                root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", buf.toString());
            }
        }
        document.appendChild(root);
    }

    @Override
    public boolean checkRootElement() {
        return this.checkRootElement(this.resource().root().getDomDocument(), this.getRootElementInfo());
    }

    protected boolean checkRootElement(Document document, RootElementInfo rinfo) {
        Element root = document.getDocumentElement();
        String localName = root.getLocalName();
        String namespace = root.getNamespaceURI();
        return MiscUtil.equal((Object)localName, (Object)rinfo.elementName) && MiscUtil.equal((Object)namespace, (Object)rinfo.namespace);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class RootElementInfo {
        public final String namespace;
        public final String defaultPrefix;
        public final String elementName;
        public final Map<String, String> schemas;

        public RootElementInfo(String namespace, String defaultPrefix, String elementName, Map<String, String> schemas) {
            this.namespace = RootElementInfo.normalizeToNull(namespace);
            this.defaultPrefix = RootElementInfo.normalizeToNull(defaultPrefix);
            if (elementName == null || elementName.length() == 0) {
                throw new IllegalArgumentException();
            }
            this.elementName = elementName.trim();
            this.schemas = schemas;
        }

        private static final String normalizeToNull(String str) {
            String normalized = str;
            if (normalized != null && (normalized = normalized.trim()).length() == 0) {
                normalized = null;
            }
            return normalized;
        }
    }
}

