/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelMetadataItem;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.GenerateImpl;
import org.eclipse.sapphire.modeling.annotations.Image;
import org.eclipse.sapphire.modeling.internal.MemoryResource;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.localization.LocalizationSystem;
import org.eclipse.sapphire.modeling.localization.LocalizationUtil;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.InitialValueService;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.internal.ElementMetaModelServiceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelElementType
extends ModelMetadataItem {
    private final Class<?> modelElementClass;
    private Class<?> implClass = null;
    private Constructor<?> implClassConstructor = null;
    private boolean implClassLoaded = false;
    private final List<ModelProperty> properties;
    private final LocalizationService localizationService;
    private ImageData image;
    private boolean imageInitialized;
    private ServiceContext serviceContext;

    public ModelElementType(Class<?> modelElementClass) {
        this.modelElementClass = modelElementClass;
        this.properties = new ArrayList<ModelProperty>();
        this.localizationService = LocalizationSystem.service(this.modelElementClass);
    }

    public static ModelElementType getModelElementType(Class<?> modelElementClass) {
        return ModelElementType.getModelElementType(modelElementClass, true);
    }

    public static ModelElementType getModelElementType(Class<?> modelElementClass, boolean throwExceptionIfNotFound) {
        Field[] fieldArray = modelElementClass.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getName().equals("TYPE")) {
                try {
                    Object fieldValue = field.get(null);
                    if (!(fieldValue instanceof ModelElementType)) break;
                    return (ModelElementType)fieldValue;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            ++n2;
        }
        if (throwExceptionIfNotFound) {
            throw new IllegalArgumentException("Did not find TYPE field on " + modelElementClass.getName());
        }
        return null;
    }

    public Class<?> getModelElementClass() {
        return this.modelElementClass;
    }

    public String getSimpleName() {
        return this.modelElementClass.getSimpleName();
    }

    public String getQualifiedName() {
        return this.modelElementClass.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getImplClass() {
        ModelElementType modelElementType = this;
        synchronized (modelElementType) {
            if (!this.implClassLoaded) {
                this.implClassLoaded = true;
                String implClassQualifiedName = ModelElementType.getImplClassName(this.modelElementClass);
                if (implClassQualifiedName != null) {
                    try {
                        this.implClass = this.modelElementClass.getClassLoader().loadClass(implClassQualifiedName);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                    if (this.implClass != null) {
                        try {
                            this.implClassConstructor = this.implClass.getConstructor(IModelParticle.class, ModelProperty.class, Resource.class);
                        }
                        catch (NoSuchMethodException e) {
                            LoggingService.log(e);
                            this.implClass = null;
                        }
                    }
                }
            }
            return this.implClass;
        }
    }

    public static String getImplClassName(Class<?> elementTypeClass) {
        if (elementTypeClass == null) {
            throw new IllegalArgumentException();
        }
        return ModelElementType.getImplClassName(elementTypeClass.getName(), elementTypeClass.getAnnotation(GenerateImpl.class));
    }

    public static String getImplClassName(String elementTypeClassName, GenerateImpl generateImplAnnotation) {
        if (elementTypeClassName == null) {
            throw new IllegalArgumentException();
        }
        if (generateImplAnnotation != null) {
            return ModelElementType.getImplClassName(elementTypeClassName, generateImplAnnotation.packageName(), generateImplAnnotation.className());
        }
        return null;
    }

    public static String getImplClassName(String elementTypeClassName, String preferredImplPackageName, String preferredImplClassName) {
        if (elementTypeClassName == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder implClassQualifiedName = new StringBuilder();
        String elementTypePackageName = null;
        int lastDotSeparator = elementTypeClassName.lastIndexOf(46);
        if (lastDotSeparator != -1) {
            elementTypePackageName = elementTypeClassName.substring(0, lastDotSeparator);
        }
        if (preferredImplPackageName == null || preferredImplPackageName.length() == 0) {
            if (elementTypePackageName != null) {
                implClassQualifiedName.append(elementTypePackageName);
                implClassQualifiedName.append('.');
            }
            implClassQualifiedName.append("internal");
        } else {
            implClassQualifiedName.append(preferredImplPackageName);
        }
        implClassQualifiedName.append('.');
        if (preferredImplClassName == null || preferredImplClassName.length() == 0) {
            String simpleTypeClassName;
            String fullTypeClassName = elementTypePackageName == null ? elementTypeClassName : elementTypeClassName.substring(elementTypePackageName.length() + 1);
            int lastSeparator = fullTypeClassName.lastIndexOf(36);
            if (lastSeparator == -1) {
                simpleTypeClassName = fullTypeClassName;
            } else {
                int simpleTypeClassNameStart = lastSeparator + 1;
                implClassQualifiedName.append(fullTypeClassName.substring(0, simpleTypeClassNameStart));
                simpleTypeClassName = fullTypeClassName.substring(simpleTypeClassNameStart);
            }
            if (simpleTypeClassName.charAt(0) == 'I' && simpleTypeClassName.length() > 1 && Character.isUpperCase(simpleTypeClassName.charAt(1))) {
                implClassQualifiedName.append(simpleTypeClassName.substring(1));
            } else {
                implClassQualifiedName.append(simpleTypeClassName);
                implClassQualifiedName.append("Impl");
            }
        } else {
            implClassQualifiedName.append(preferredImplClassName);
        }
        return implClassQualifiedName.toString();
    }

    public <T extends IModelElement> T instantiate(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        this.getImplClass();
        if (this.implClassConstructor != null) {
            IModelElement element;
            try {
                element = (IModelElement)this.implClassConstructor.newInstance(parent, parentProperty, resource);
            }
            catch (Exception e) {
                String msg = NLS.bind(Resources.cannotInstantiate, this.getSimpleName());
                throw new RuntimeException(msg, e);
            }
            for (ModelProperty property : this.properties) {
                InitialValueService initialValueService;
                if (!(property instanceof ValueProperty) || (initialValueService = element.service(property, InitialValueService.class)) == null) continue;
                element.write((ValueProperty)property, (Object)initialValueService.value());
            }
            return (T)element;
        }
        String msg = NLS.bind(Resources.cannotInstantiate, this.getSimpleName());
        throw new RuntimeException(msg);
    }

    public <T extends IModelElement> T instantiate(Resource resource) {
        return this.instantiate(null, null, resource);
    }

    public <T extends IModelElement> T instantiate() {
        return this.instantiate(null, null, new MemoryResource(this));
    }

    public List<ModelProperty> getProperties() {
        TreeMap<String, ModelProperty> properties = new TreeMap<String, ModelProperty>();
        Class<?>[] classArray = this.modelElementClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cl = classArray[n2];
            ModelElementType t = ModelElementType.getModelElementType(cl, false);
            if (t != null) {
                for (ModelProperty property : t.getProperties()) {
                    properties.put(property.getName(), property);
                }
            }
            ++n2;
        }
        for (ModelProperty property : this.properties) {
            properties.put(property.getName(), property);
        }
        return new ArrayList<ModelProperty>(properties.values());
    }

    public ModelProperty getProperty(String propertyName) {
        for (ModelProperty property : this.getProperties()) {
            if (!property.getName().equalsIgnoreCase(propertyName)) continue;
            return property;
        }
        return null;
    }

    void addProperty(ModelProperty property) {
        this.properties.add(property);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> type, boolean localOnly) {
        return this.modelElementClass.getAnnotation(type);
    }

    public Class<?> getAnnotationHostClass(Annotation annotation) {
        return this.modelElementClass;
    }

    @Override
    protected String getDefaultLabel() {
        String className = this.modelElementClass.getName();
        int start = className.lastIndexOf(46) + 1;
        int startPlusOne = start + 1;
        if (className.charAt(start) == 'I' && startPlusOne < className.length() && Character.isUpperCase(className.charAt(startPlusOne))) {
            start = startPlusOne;
        }
        if (start > 0) {
            className = className.substring(start);
        }
        return LocalizationUtil.transformCamelCaseToLabel(className);
    }

    @Override
    public LocalizationService getLocalizationService() {
        return this.localizationService;
    }

    public ImageData image() {
        if (!this.imageInitialized) {
            Image imageAnnotation = this.getAnnotation(Image.class);
            if (imageAnnotation != null) {
                try {
                    this.image = ImageData.createFromClassLoader(this.getAnnotationHostClass(imageAnnotation), imageAnnotation.path());
                }
                catch (Exception e) {
                    LoggingService.log(e);
                }
            }
            this.imageInitialized = true;
        }
        return this.image;
    }

    public <S extends Service> S service(Class<S> serviceType) {
        List<S> services = this.services(serviceType);
        return (S)(services.isEmpty() ? null : (Service)services.get(0));
    }

    public <S extends Service> List<S> services(Class<S> serviceType) {
        return this.services().services(serviceType);
    }

    public synchronized ServiceContext services() {
        if (this.serviceContext == null) {
            this.serviceContext = new ElementMetaModelServiceContext(this);
        }
        return this.serviceContext;
    }

    protected static abstract class ModelPropertyInitListener {
        protected ModelPropertyInitListener() {
        }

        public abstract void propertyInitialized(ModelProperty var1);
    }

    private static final class Resources
    extends NLS {
        public static String cannotInstantiate;

        static {
            Resources.initializeMessages(ModelElementType.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

