/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.EnumValueType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;
import org.eclipse.sapphire.services.ValueLabelService;
import org.eclipse.sapphire.services.ValueSerializationService;

public final class EnumValueLabelService
extends ValueLabelService {
    private EnumValueType enumType;
    private ValueSerializationService valueSerializationService;

    protected void init() {
        super.init();
        IModelElement element = this.context(IModelElement.class);
        ValueProperty property = this.context(ValueProperty.class);
        this.enumType = new EnumValueType(property.getTypeClass());
        this.valueSerializationService = element.service(property, ValueSerializationService.class);
    }

    public String provide(String value) {
        Enum item = (Enum)this.valueSerializationService.decode(value);
        if (item == null) {
            return value;
        }
        return this.enumType.getLabel(item, false, CapitalizationType.NO_CAPS, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            ValueProperty property = context.find(ValueProperty.class);
            return property != null && Enum.class.isAssignableFrom(property.getTypeClass());
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new EnumValueLabelService();
        }
    }
}

