/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.address.internal;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.samples.address.Address;
import org.eclipse.sapphire.services.ValueNormalizationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AddressImpl
extends ModelElement
implements Address {
    private Value<String> city;
    private Value<String> state;
    private Value<String> street;
    private Value<String> zipCode;

    public AddressImpl(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public AddressImpl(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getCity() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.city == null) {
                this.refresh((ModelProperty)PROP_CITY, true);
            }
            return this.city;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCity(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_CITY.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_CITY, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_CITY, true);
            if (!AddressImpl.equal((String)this.city.getText(false), (String)value)) {
                this.resource().binding(PROP_CITY).write(value);
                this.refresh((ModelProperty)PROP_CITY, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getState() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.state == null) {
                this.refresh((ModelProperty)PROP_STATE, true);
            }
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setState(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_STATE.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_STATE, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_STATE, true);
            if (!AddressImpl.equal((String)this.state.getText(false), (String)value)) {
                this.resource().binding(PROP_STATE).write(value);
                this.refresh((ModelProperty)PROP_STATE, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getStreet() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.street == null) {
                this.refresh((ModelProperty)PROP_STREET, true);
            }
            return this.street;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStreet(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_STREET.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_STREET, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_STREET, true);
            if (!AddressImpl.equal((String)this.street.getText(false), (String)value)) {
                this.resource().binding(PROP_STREET).write(value);
                this.refresh((ModelProperty)PROP_STREET, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getZipCode() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.zipCode == null) {
                this.refresh((ModelProperty)PROP_ZIP_CODE, true);
            }
            return this.zipCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setZipCode(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_ZIP_CODE.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_ZIP_CODE, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_ZIP_CODE, true);
            if (!AddressImpl.equal((String)this.zipCode.getText(false), (String)value)) {
                this.resource().binding(PROP_ZIP_CODE).write(value);
                this.refresh((ModelProperty)PROP_ZIP_CODE, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_CITY) {
                if (this.city != null || force) {
                    Value<String> oldValue = this.city;
                    String val = this.resource().binding(PROP_CITY).read();
                    this.city = new Value((IModelElement)this, PROP_CITY, ((ValueNormalizationService)this.service((ModelProperty)PROP_CITY, ValueNormalizationService.class)).normalize(PROP_CITY.encodeKeywords(val)));
                    this.city.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_CITY);
                    if (oldValue != null) {
                        if (this.city.equals(oldValue)) {
                            this.city = oldValue;
                        }
                        if (this.city != oldValue || enablementRefreshResult.changed()) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_CITY, enablementRefreshResult);
                        }
                    }
                }
            } else if (property == PROP_STATE) {
                if (this.state != null || force) {
                    Value<String> oldValue = this.state;
                    String val = this.resource().binding(PROP_STATE).read();
                    this.state = new Value((IModelElement)this, PROP_STATE, ((ValueNormalizationService)this.service((ModelProperty)PROP_STATE, ValueNormalizationService.class)).normalize(PROP_STATE.encodeKeywords(val)));
                    this.state.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_STATE);
                    if (oldValue != null) {
                        if (this.state.equals(oldValue)) {
                            this.state = oldValue;
                        }
                        if (this.state != oldValue || enablementRefreshResult.changed()) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_STATE, enablementRefreshResult);
                        }
                    }
                }
            } else if (property == PROP_STREET) {
                if (this.street != null || force) {
                    Value<String> oldValue = this.street;
                    String val = this.resource().binding(PROP_STREET).read();
                    this.street = new Value((IModelElement)this, PROP_STREET, ((ValueNormalizationService)this.service((ModelProperty)PROP_STREET, ValueNormalizationService.class)).normalize(PROP_STREET.encodeKeywords(val)));
                    this.street.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_STREET);
                    if (oldValue != null) {
                        if (this.street.equals(oldValue)) {
                            this.street = oldValue;
                        }
                        if (this.street != oldValue || enablementRefreshResult.changed()) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_STREET, enablementRefreshResult);
                        }
                    }
                }
            } else if (property == PROP_ZIP_CODE && (this.zipCode != null || force)) {
                Value<String> oldValue = this.zipCode;
                String val = this.resource().binding(PROP_ZIP_CODE).read();
                this.zipCode = new Value((IModelElement)this, PROP_ZIP_CODE, ((ValueNormalizationService)this.service((ModelProperty)PROP_ZIP_CODE, ValueNormalizationService.class)).normalize(PROP_ZIP_CODE.encodeKeywords(val)));
                this.zipCode.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_ZIP_CODE);
                if (oldValue != null) {
                    if (this.zipCode.equals(oldValue)) {
                        this.zipCode = oldValue;
                    }
                    if (this.zipCode != oldValue || enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_ZIP_CODE, enablementRefreshResult);
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_CITY) {
            return this.getCity();
        }
        if (property == PROP_STATE) {
            return this.getState();
        }
        if (property == PROP_STREET) {
            return this.getStreet();
        }
        if (property == PROP_ZIP_CODE) {
            return this.getZipCode();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_CITY) {
            this.setCity((String)value);
            return;
        }
        if (property == PROP_STATE) {
            this.setState((String)value);
            return;
        }
        if (property == PROP_STREET) {
            this.setStreet((String)value);
            return;
        }
        if (property == PROP_ZIP_CODE) {
            this.setZipCode((String)value);
            return;
        }
        super.write(property, value);
    }
}

