/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.gallery.internal;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.samples.gallery.IValuePropertyActionsGalleryReference;
import org.eclipse.sapphire.services.ValueNormalizationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValuePropertyActionsGalleryReference
extends ModelElement
implements IValuePropertyActionsGalleryReference {
    private Value<String> reference;

    public ValuePropertyActionsGalleryReference(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public ValuePropertyActionsGalleryReference(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getReference() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.reference == null) {
                this.refresh((ModelProperty)PROP_REFERENCE, true);
            }
            return this.reference;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReference(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_REFERENCE.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_REFERENCE, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_REFERENCE, true);
            if (!ValuePropertyActionsGalleryReference.equal((String)this.reference.getText(false), (String)value)) {
                this.resource().binding(PROP_REFERENCE).write(value);
                this.refresh((ModelProperty)PROP_REFERENCE, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_REFERENCE && (this.reference != null || force)) {
                Value<String> oldValue = this.reference;
                String val = this.resource().binding(PROP_REFERENCE).read();
                this.reference = new Value((IModelElement)this, PROP_REFERENCE, ((ValueNormalizationService)this.service((ModelProperty)PROP_REFERENCE, ValueNormalizationService.class)).normalize(PROP_REFERENCE.encodeKeywords(val)));
                this.reference.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_REFERENCE);
                if (oldValue != null) {
                    if (this.reference.equals(oldValue)) {
                        this.reference = oldValue;
                    }
                    if (this.reference != oldValue || enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_REFERENCE, enablementRefreshResult);
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_REFERENCE) {
            return this.getReference();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_REFERENCE) {
            this.setReference((String)value);
            return;
        }
        super.write(property, value);
    }
}

