/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.xml.binding.t0009;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.CorruptedResourceExceptionInterceptor;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.modeling.xml.binding.t0009.ITestChildElementA;
import org.eclipse.sapphire.tests.modeling.xml.binding.t0009.ITestChildElementB;
import org.eclipse.sapphire.tests.modeling.xml.binding.t0009.ITestRootElement;
import org.eclipse.sapphire.tests.modeling.xml.binding.t0009.TestChildElementA;
import org.eclipse.sapphire.tests.modeling.xml.binding.t0009.TestChildElementB;
import org.eclipse.sapphire.tests.modeling.xml.binding.t0009.TestRootElement;

public final class TestXmlBinding0009
extends SapphireTestCase {
    private TestXmlBinding0009(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("TestXmlBinding0009");
        suite.addTest((Test)new TestXmlBinding0009("testDefaultBindingWrite1"));
        suite.addTest((Test)new TestXmlBinding0009("testDefaultBindingWrite2"));
        suite.addTest((Test)new TestXmlBinding0009("testDefaultBindingRead1"));
        suite.addTest((Test)new TestXmlBinding0009("testDefaultBindingRead2"));
        return suite;
    }

    public void testDefaultBindingWrite1() throws Exception {
        ByteArrayResourceStore resourceStore = new ByteArrayResourceStore();
        XmlResourceStore xmlResourceStore = new XmlResourceStore(resourceStore);
        TestRootElement model = (TestRootElement)TestRootElement.TYPE.instantiate((Resource)new RootXmlResource(xmlResourceStore));
        model.resource().setCorruptedResourceExceptionInterceptor(new CorruptedResourceExceptionInterceptor(){

            public boolean shouldAttemptRepair() {
                return true;
            }
        });
        model.setValuePropertyA("aaaa");
        model.setValuePropertyB("bbbb");
        TestChildElementA listChild1 = (TestChildElementA)model.getListPropertyA().addNewElement(TestChildElementA.TYPE);
        listChild1.setValuePropertyA("cccc");
        TestChildElementB listChild2 = (TestChildElementB)model.getListPropertyA().addNewElement(TestChildElementB.TYPE);
        listChild2.setValuePropertyB("dddd");
        TestChildElementA listChild3 = (TestChildElementA)model.getListPropertyA().addNewElement(TestChildElementA.TYPE);
        listChild3.setValuePropertyA("eeee");
        TestChildElementB elementChild = (TestChildElementB)model.getElementPropertyA().element(true, TestChildElementB.TYPE);
        elementChild.setValuePropertyB("ffff");
        model.resource().save();
        String result = new String(resourceStore.getContents(), "UTF-8");
        TestXmlBinding0009.assertEqualsIgnoreNewLineDiffs(this.loadResource("TestData.txt"), result);
    }

    public void testDefaultBindingWrite2() throws Exception {
        ByteArrayResourceStore resourceStore = new ByteArrayResourceStore();
        XmlResourceStore xmlResourceStore = new XmlResourceStore(resourceStore);
        ITestRootElement model = (ITestRootElement)ITestRootElement.TYPE.instantiate((Resource)new RootXmlResource(xmlResourceStore));
        model.resource().setCorruptedResourceExceptionInterceptor(new CorruptedResourceExceptionInterceptor(){

            public boolean shouldAttemptRepair() {
                return true;
            }
        });
        model.setValuePropertyA("aaaa");
        model.setValuePropertyB("bbbb");
        ITestChildElementA listChild1 = (ITestChildElementA)model.getListPropertyA().addNewElement(ITestChildElementA.TYPE);
        listChild1.setValuePropertyA("cccc");
        ITestChildElementB listChild2 = (ITestChildElementB)model.getListPropertyA().addNewElement(ITestChildElementB.TYPE);
        listChild2.setValuePropertyB("dddd");
        ITestChildElementA listChild3 = (ITestChildElementA)model.getListPropertyA().addNewElement(ITestChildElementA.TYPE);
        listChild3.setValuePropertyA("eeee");
        ITestChildElementB elementChild = (ITestChildElementB)model.getElementPropertyA().element(true, ITestChildElementB.TYPE);
        elementChild.setValuePropertyB("ffff");
        model.resource().save();
        String result = new String(resourceStore.getContents(), "UTF-8");
        TestXmlBinding0009.assertEqualsIgnoreNewLineDiffs(this.loadResource("TestData.txt"), result);
    }

    public void testDefaultBindingRead1() throws Exception {
        ByteArrayResourceStore resourceStore = new ByteArrayResourceStore(this.loadResourceAsStream("TestData.txt"));
        XmlResourceStore xmlResourceStore = new XmlResourceStore(resourceStore);
        TestRootElement model = (TestRootElement)TestRootElement.TYPE.instantiate((Resource)new RootXmlResource(xmlResourceStore));
        TestXmlBinding0009.assertEquals((String)"aaaa", (String)model.getValuePropertyA().getText());
        TestXmlBinding0009.assertEquals((String)"bbbb", (String)model.getValuePropertyB().getText());
        TestXmlBinding0009.assertEquals((int)3, (int)model.getListPropertyA().size());
        TestXmlBinding0009.assertEquals((String)"cccc", (String)((TestChildElementA)model.getListPropertyA().get(0)).getValuePropertyA().getText());
        TestXmlBinding0009.assertEquals((String)"dddd", (String)((TestChildElementB)model.getListPropertyA().get(1)).getValuePropertyB().getText());
        TestXmlBinding0009.assertEquals((String)"eeee", (String)((TestChildElementA)model.getListPropertyA().get(2)).getValuePropertyA().getText());
        TestXmlBinding0009.assertEquals((String)"ffff", (String)((TestChildElementB)model.getElementPropertyA().element(false)).getValuePropertyB().getText());
    }

    public void testDefaultBindingRead2() throws Exception {
        ByteArrayResourceStore resourceStore = new ByteArrayResourceStore(this.loadResourceAsStream("TestData.txt"));
        XmlResourceStore xmlResourceStore = new XmlResourceStore(resourceStore);
        ITestRootElement model = (ITestRootElement)ITestRootElement.TYPE.instantiate((Resource)new RootXmlResource(xmlResourceStore));
        TestXmlBinding0009.assertEquals((String)"aaaa", (String)model.getValuePropertyA().getText());
        TestXmlBinding0009.assertEquals((String)"bbbb", (String)model.getValuePropertyB().getText());
        TestXmlBinding0009.assertEquals((int)3, (int)model.getListPropertyA().size());
        TestXmlBinding0009.assertEquals((String)"cccc", (String)((ITestChildElementA)model.getListPropertyA().get(0)).getValuePropertyA().getText());
        TestXmlBinding0009.assertEquals((String)"dddd", (String)((ITestChildElementB)model.getListPropertyA().get(1)).getValuePropertyB().getText());
        TestXmlBinding0009.assertEquals((String)"eeee", (String)((ITestChildElementA)model.getListPropertyA().get(2)).getValuePropertyA().getText());
        TestXmlBinding0009.assertEquals((String)"ffff", (String)((ITestChildElementB)model.getElementPropertyA().element(false)).getValuePropertyB().getText());
    }
}

