/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.services.t0001;

import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.services.FactsAggregationService;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.services.t0001.TestNoDuplicatesChildElement;
import org.eclipse.sapphire.tests.services.t0001.TestRootElement;

public final class TestServices0001
extends SapphireTestCase {
    private TestServices0001(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("TestServices0001");
        suite.addTest((Test)new TestServices0001("testNoFacts"));
        suite.addTest((Test)new TestServices0001("testDefaultValue"));
        suite.addTest((Test)new TestServices0001("testNumericRangeMin"));
        suite.addTest((Test)new TestServices0001("testNumericRangeMax"));
        suite.addTest((Test)new TestServices0001("testNumericRangeMinMax"));
        suite.addTest((Test)new TestServices0001("testReadOnly"));
        suite.addTest((Test)new TestServices0001("testCountConstraintAtLeastOne"));
        suite.addTest((Test)new TestServices0001("testCountConstraintMin"));
        suite.addTest((Test)new TestServices0001("testCountConstraintMax"));
        suite.addTest((Test)new TestServices0001("testCountConstraintMinMax"));
        suite.addTest((Test)new TestServices0001("testAbsolutePath"));
        suite.addTest((Test)new TestServices0001("testMustExist"));
        suite.addTest((Test)new TestServices0001("testMustExistAbsolutePath"));
        suite.addTest((Test)new TestServices0001("testNoDuplicates"));
        suite.addTest((Test)new TestServices0001("testFileExtensionsOne"));
        suite.addTest((Test)new TestServices0001("testFileExtensionsTwo"));
        suite.addTest((Test)new TestServices0001("testFileExtensionsThree"));
        suite.addTest((Test)new TestServices0001("testFileExtensionsMany"));
        suite.addTest((Test)new TestServices0001("testValidFileSystemResourceTypeFile"));
        suite.addTest((Test)new TestServices0001("testValidFileSystemResourceTypeFolder"));
        suite.addTest((Test)new TestServices0001("testDeprecated"));
        suite.addTest((Test)new TestServices0001("testStatic"));
        return suite;
    }

    public void testNoFacts() throws Exception {
        TestServices0001.test((ModelProperty)TestRootElement.PROP_NO_FACTS, new String[0]);
    }

    public void testDefaultValue() throws Exception {
        TestServices0001.test((ModelProperty)TestRootElement.PROP_DEFAULT_VALUE, "Default value is \"123\".");
    }

    public void testNumericRangeMin() throws Exception {
        TestServices0001.test((ModelProperty)TestRootElement.PROP_NUMERIC_RANGE_MIN, "Minimum value is 1.");
    }

    public void testNumericRangeMax() throws Exception {
        TestServices0001.test((ModelProperty)TestRootElement.PROP_NUMERIC_RANGE_MAX, "Maximum value is 100.");
    }

    public void testNumericRangeMinMax() throws Exception {
        TestServices0001.test((ModelProperty)TestRootElement.PROP_NUMERIC_RANGE_MIN_MAX, "Minimum value is 1.", "Maximum value is 100.");
    }

    public void testRequiredValue() throws Exception {
        TestServices0001.test((ModelProperty)TestRootElement.PROP_REQUIRED_VALUE, "Must be specified.");
    }

    public void testRequiredElement() throws Exception {
        TestServices0001.test((ModelProperty)TestRootElement.PROP_REQUIRED_ELEMENT, "Must be specified.");
    }

    public void testReadOnly() throws Exception {
        TestServices0001.test((ModelProperty)TestRootElement.PROP_READ_ONLY, "Cannot be modified.");
    }

    public void testCountConstraintAtLeastOne() throws Exception {
        TestServices0001.test((ModelProperty)TestRootElement.PROP_COUNT_CONSTRAINT_AT_LEAST_ONE, "Must have at least one.");
    }

    public void testCountConstraintMin() throws Exception {
        TestServices0001.test((ModelProperty)TestRootElement.PROP_COUNT_CONSTRAINT_MIN, "Must have at least 2 items.");
    }

    public void testCountConstraintMax() throws Exception {
        TestServices0001.test((ModelProperty)TestRootElement.PROP_COUNT_CONSTRAINT_MAX, "Must have at most 200 items.");
    }

    public void testCountConstraintMinMax() throws Exception {
        TestServices0001.test((ModelProperty)TestRootElement.PROP_COUNT_CONSTRAINT_MIN_MAX, "Must have at least 2 items.", "Must have at most 200 items.");
    }

    public void testAbsolutePath() throws Exception {
        TestServices0001.test((ModelProperty)TestRootElement.PROP_ABSOLUTE_PATH, "Must be an absolute path.");
    }

    public void testMustExist() throws Exception {
        TestServices0001.test((ModelProperty)TestRootElement.PROP_MUST_EXIST, "Must exist.");
    }

    public void testMustExistAbsolutePath() throws Exception {
        TestServices0001.test((ModelProperty)TestRootElement.PROP_MUST_EXIST_ABSOLUTE_PATH, "Must be an absolute path.", "Must exist.");
    }

    public void testNoDuplicates() throws Exception {
        TestRootElement root = (TestRootElement)TestRootElement.TYPE.instantiate();
        TestNoDuplicatesChildElement child = (TestNoDuplicatesChildElement)root.getNoDuplicates().addNewElement();
        TestServices0001.test(child, (ModelProperty)TestNoDuplicatesChildElement.PROP_NO_DUPLICATES, "Must be unique.");
    }

    public void testFileExtensionsOne() throws Exception {
        TestServices0001.test((ModelProperty)TestRootElement.PROP_FILE_EXTENSIONS_ONE, "Must have \"xml\" file extension.");
    }

    public void testFileExtensionsTwo() throws Exception {
        TestServices0001.test((ModelProperty)TestRootElement.PROP_FILE_EXTENSIONS_TWO, "Must have either \"xml\" or \"java\" file extension.");
    }

    public void testFileExtensionsThree() throws Exception {
        TestServices0001.test((ModelProperty)TestRootElement.PROP_FILE_EXTENSIONS_THREE, "Must have either \"xml\", \"java\" or \"jsp\" file extension.");
    }

    public void testFileExtensionsMany() throws Exception {
        TestServices0001.test((ModelProperty)TestRootElement.PROP_FILE_EXTENSIONS_MANY, "Must have one of these file extensions: \"xml\", \"java\", \"jsp\", \"jspx\".");
    }

    public void testValidFileSystemResourceTypeFile() throws Exception {
        TestServices0001.test((ModelProperty)TestRootElement.PROP_VALID_FILE_SYSTEM_RESOURCE_TYPE_FILE, "Must be a file.");
    }

    public void testValidFileSystemResourceTypeFolder() throws Exception {
        TestServices0001.test((ModelProperty)TestRootElement.PROP_VALID_FILE_SYSTEM_RESOURCE_TYPE_FOLDER, "Must be a folder.");
    }

    public void testDeprecated() throws Exception {
        TestServices0001.test((ModelProperty)TestRootElement.PROP_DEPRECATED, "Deprecated.");
    }

    public void testStatic() throws Exception {
        TestServices0001.test((ModelProperty)TestRootElement.PROP_STATIC_FACT, "First static fact.", "Second static fact.", "Third static fact.");
    }

    private static void test(ModelProperty property, String ... factsExpected) {
        TestServices0001.test(TestRootElement.TYPE.instantiate(), property, factsExpected);
    }

    private static void test(IModelElement element, ModelProperty property, String ... factsExpected) {
        List factsActual = ((FactsAggregationService)element.service(property, FactsAggregationService.class)).facts();
        TestServices0001.assertEquals(Arrays.asList(factsExpected), (Object)factsActual);
    }
}

