/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.services.t0002;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.services.FileExtensionsService;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.services.t0002.TestModel;
import org.eclipse.sapphire.tests.services.t0002.TestModelRoot;

public final class TestServices0002
extends SapphireTestCase {
    private TestServices0002(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("TestServices0002");
        suite.addTest((Test)new TestServices0002("testNoFileExtensionsService"));
        suite.addTest((Test)new TestServices0002("testSingleFileExtension"));
        suite.addTest((Test)new TestServices0002("testMultipleFileExtensions"));
        suite.addTest((Test)new TestServices0002("testFileExtensionsExpr1"));
        suite.addTest((Test)new TestServices0002("testFileExtensionsExpr2"));
        suite.addTest((Test)new TestServices0002("testFileExtensionsExpr3"));
        suite.addTest((Test)new TestServices0002("testFileExtensionsExpr4"));
        suite.addTest((Test)new TestServices0002("testCustomFileExtensionsService"));
        suite.addTest((Test)new TestServices0002("testValidation"));
        return suite;
    }

    public void testNoFileExtensionsService() throws Exception {
        TestModel model = (TestModel)TestModel.TYPE.instantiate();
        FileExtensionsService service = (FileExtensionsService)model.service((ModelProperty)TestModel.PROP_FILE_PATH_1, FileExtensionsService.class);
        TestServices0002.assertNull((Object)service);
    }

    public void testSingleFileExtension() throws Exception {
        TestModel model = (TestModel)TestModel.TYPE.instantiate();
        FileExtensionsService service = (FileExtensionsService)model.service((ModelProperty)TestModel.PROP_FILE_PATH_2, FileExtensionsService.class);
        TestServices0002.assertNotNull((Object)service);
        TestServices0002.assertEquals(TestServices0002.list("png"), (Object)service.extensions());
    }

    public void testMultipleFileExtensions() throws Exception {
        TestModel model = (TestModel)TestModel.TYPE.instantiate();
        FileExtensionsService service = (FileExtensionsService)model.service((ModelProperty)TestModel.PROP_FILE_PATH_3, FileExtensionsService.class);
        TestServices0002.assertNotNull((Object)service);
        TestServices0002.assertEquals(TestServices0002.list("png", "gif", "jpeg"), (Object)service.extensions());
    }

    public void testFileExtensionsExpr1() throws Exception {
        TestModel model = (TestModel)TestModel.TYPE.instantiate();
        FileExtensionsService service = (FileExtensionsService)model.service((ModelProperty)TestModel.PROP_FILE_PATH_4, FileExtensionsService.class);
        TestServices0002.assertNotNull((Object)service);
        model.setLossyCompression(true);
        TestServices0002.assertEquals(TestServices0002.list("jpeg"), (Object)service.extensions());
        model.setLossyCompression(false);
        TestServices0002.assertEquals(TestServices0002.list("png", "gif"), (Object)service.extensions());
    }

    public void testFileExtensionsExpr2() throws Exception {
        TestModelRoot root = (TestModelRoot)TestModelRoot.TYPE.instantiate();
        TestModel model = (TestModel)root.getList().addNewElement();
        FileExtensionsService service = (FileExtensionsService)model.service((ModelProperty)TestModel.PROP_FILE_PATH_5, FileExtensionsService.class);
        TestServices0002.assertNotNull((Object)service);
        root.setLossyCompression(true);
        TestServices0002.assertEquals(TestServices0002.list("jpeg"), (Object)service.extensions());
        root.setLossyCompression(false);
        TestServices0002.assertEquals(TestServices0002.list("png", "gif"), (Object)service.extensions());
    }

    public void testFileExtensionsExpr3() throws Exception {
        TestModelRoot root = (TestModelRoot)TestModelRoot.TYPE.instantiate();
        TestModel model = (TestModel)root.getElement().element(true);
        FileExtensionsService service = (FileExtensionsService)model.service((ModelProperty)TestModel.PROP_FILE_PATH_5, FileExtensionsService.class);
        TestServices0002.assertNotNull((Object)service);
        root.setLossyCompression(true);
        TestServices0002.assertEquals(TestServices0002.list("jpeg"), (Object)service.extensions());
        root.setLossyCompression(false);
        TestServices0002.assertEquals(TestServices0002.list("png", "gif"), (Object)service.extensions());
    }

    public void testFileExtensionsExpr4() throws Exception {
        TestModelRoot root = (TestModelRoot)TestModelRoot.TYPE.instantiate();
        TestModel model = root.getElementImplied();
        FileExtensionsService service = (FileExtensionsService)model.service((ModelProperty)TestModel.PROP_FILE_PATH_5, FileExtensionsService.class);
        TestServices0002.assertNotNull((Object)service);
        root.setLossyCompression(true);
        TestServices0002.assertEquals(TestServices0002.list("jpeg"), (Object)service.extensions());
        root.setLossyCompression(false);
        TestServices0002.assertEquals(TestServices0002.list("png", "gif"), (Object)service.extensions());
    }

    public void testCustomFileExtensionsService() throws Exception {
        TestModel model = (TestModel)TestModel.TYPE.instantiate();
        FileExtensionsService service = (FileExtensionsService)model.service((ModelProperty)TestModel.PROP_FILE_PATH_6, FileExtensionsService.class);
        TestServices0002.assertNotNull((Object)service);
        TestServices0002.assertEquals(TestServices0002.list("avi", "mpeg"), (Object)service.extensions());
    }

    public void testValidation() throws Exception {
        TestModel model = (TestModel)TestModel.TYPE.instantiate();
        FileExtensionsService service = (FileExtensionsService)model.service((ModelProperty)TestModel.PROP_FILE_PATH_4, FileExtensionsService.class);
        IProject project = this.project();
        IFile txtFile = project.getFile("file.txt");
        String txtFilePath = txtFile.getLocation().toOSString();
        txtFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
        IFile jpegFile = project.getFile("file.jpeg");
        String jpegFilePath = jpegFile.getLocation().toOSString();
        jpegFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
        IFile pngFile = project.getFile("file.png");
        String pngFilePath = pngFile.getLocation().toOSString();
        pngFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
        TestServices0002.assertNotNull((Object)service);
        model.setLossyCompression(true);
        TestServices0002.assertEquals(TestServices0002.list("jpeg"), (Object)service.extensions());
        model.setFilePath4(txtFilePath);
        TestServices0002.assertValidationError(model.getFilePath4(), "File \"file.txt\" has an invalid extension. Only \"jpeg\" extension is allowed.");
        model.setFilePath4(jpegFilePath);
        TestServices0002.assertValidationOk(model.getFilePath4());
        model.setLossyCompression(false);
        TestServices0002.assertEquals(TestServices0002.list("png", "gif"), (Object)service.extensions());
        TestServices0002.assertValidationError(model.getFilePath4(), "File \"file.jpeg\" has an invalid extension. Only extensions \"png\" and \"gif\" are allowed.");
        model.setFilePath4(pngFilePath);
        TestServices0002.assertValidationOk(model.getFilePath4());
    }
}

