/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.graphiti.actions;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.ui.Point;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireActionHandlerDef;
import org.eclipse.sapphire.ui.diagram.SapphireDiagramActionHandler;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.renderers.swt.SwtRendererUtil;
import org.eclipse.sapphire.ui.swt.graphiti.DiagramRenderingContext;

public class DiagramNodeAddActionHandler
extends SapphireDiagramActionHandler {
    private DiagramNodeTemplate nodeTemplate;

    public DiagramNodeAddActionHandler(DiagramNodeTemplate nodeTemplate) {
        this.nodeTemplate = nodeTemplate;
    }

    public void init(SapphireAction action, ISapphireActionHandlerDef def) {
        ImageDescriptor typeSpecificAddImage;
        super.init(action, def);
        if (this.nodeTemplate.getToolPaletteLabel() != null) {
            this.setLabel(this.nodeTemplate.getToolPaletteLabel());
        }
        if ((typeSpecificAddImage = SwtRendererUtil.toImageDescriptor((ImageData)this.nodeTemplate.getNodeType().image())) != null) {
            this.addImage(typeSpecificAddImage);
        }
    }

    public boolean isEnabled() {
        SapphireDiagramEditorPagePart diagramPart = (SapphireDiagramEditorPagePart)this.nodeTemplate.getParentPart();
        return diagramPart.isNodeTemplateVisible(this.nodeTemplate);
    }

    public boolean canExecute(Object obj) {
        return true;
    }

    protected Object run(SapphireRenderingContext context) {
        DiagramNodePart nodePart = this.nodeTemplate.createNewDiagramNode();
        DiagramRenderingContext drc = (DiagramRenderingContext)context;
        Point pt = drc.getCurrentMouseLocation();
        drc.getDiagramEditor().getDiagramTypeProvider().getFeatureProvider().getDirectEditingInfo().setActive(true);
        nodePart.setNodePosition(pt.getX(), pt.getY());
        return nodePart;
    }
}

