/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.graphiti.actions;

import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.localization.LabelTransformer;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.swt.graphiti.DiagramRenderingContext;
import org.eclipse.sapphire.ui.swt.graphiti.editor.SapphireDiagramEditor;
import org.eclipse.sapphire.ui.swt.graphiti.providers.SapphireDiagramFeatureProvider;

public class SapphireActionHandlerDelegate
extends Action {
    private SapphireDiagramEditor diagramEditor;
    private SapphireActionHandler sapphireActionHandler;

    public SapphireActionHandlerDelegate(SapphireDiagramEditor diagramEditor, SapphireActionHandler sapphireActionHandler) {
        this.diagramEditor = diagramEditor;
        this.sapphireActionHandler = sapphireActionHandler;
        this.setEnabled(this.sapphireActionHandler.isEnabled());
        this.setChecked(this.sapphireActionHandler.isChecked());
    }

    public String getText() {
        String text = this.sapphireActionHandler.getAction().getActiveHandlers().size() == 1 ? this.sapphireActionHandler.getAction().getLabel() : this.sapphireActionHandler.getLabel();
        return LabelTransformer.transform((String)text, (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)true);
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.sapphireActionHandler.getImage(16) != null) {
            return this.sapphireActionHandler.getImage(16);
        }
        return this.sapphireActionHandler.getAction().getImage(16);
    }

    public void run() {
        this.sapphireActionHandler.attach(new Listener(){

            public void handle(Event event) {
                if (event instanceof SapphireActionHandler.PostExecuteEvent) {
                    SapphireActionHandlerDelegate.this.handlePostExecutionEvent((SapphireActionHandler.PostExecuteEvent)event);
                }
            }
        });
        SapphireDiagramFeatureProvider fp = (SapphireDiagramFeatureProvider)this.diagramEditor.getDiagramTypeProvider().getFeatureProvider();
        DiagramRenderingContext context = fp.getRenderingContext((ISapphirePart)((SapphirePart)this.sapphireActionHandler.getPart()));
        ILocation loc = context.getDiagramEditor().getCurrentMouseLocation();
        context.setCurrentMouseLocation(loc.getX(), loc.getY());
        this.sapphireActionHandler.execute((SapphireRenderingContext)context);
    }

    public SapphireActionHandler getSapphireActionHandler() {
        return this.sapphireActionHandler;
    }

    protected void handlePostExecutionEvent(SapphireActionHandler.PostExecuteEvent event) {
    }
}

