/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphirePartContainer;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.SplitFormBlockPart;
import org.eclipse.sapphire.ui.def.Orientation;
import org.eclipse.sapphire.ui.def.SplitFormBlockDef;
import org.eclipse.sapphire.ui.def.SplitFormDef;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SplitFormPart
extends SapphirePartContainer {
    @Override
    protected List<SapphirePart> initChildParts() {
        IModelElement element = this.getLocalModelElement();
        ArrayList<SapphirePart> childParts = new ArrayList<SapphirePart>();
        for (SplitFormBlockDef splitFormBlockDef : this.getDefinition().getBlocks()) {
            SapphirePart childPart = SplitFormPart.create(this, element, splitFormBlockDef, this.params);
            childParts.add(childPart);
        }
        return childParts;
    }

    @Override
    public SplitFormDef getDefinition() {
        return (SplitFormDef)super.getDefinition();
    }

    public Orientation getOrientation() {
        return (Orientation)((Object)this.getDefinition().getOrientation().getContent());
    }

    public List<SplitFormBlockPart> getChildParts() {
        return super.getChildParts();
    }

    @Override
    public final void render(SapphireRenderingContext context) {
        SashForm form = new SashForm(context.getComposite(), (this.getOrientation() == Orientation.HORIZONTAL ? 256 : 512) | 0x10000);
        form.setLayoutData((Object)GridLayoutUtil.gdhspan(this.getScaleVertically() ? GridLayoutUtil.gdfill() : GridLayoutUtil.gdhfill(), 2));
        context.adapt((Control)form);
        List<SplitFormBlockPart> blockParts = this.getChildParts();
        int blockPartsCount = blockParts.size();
        int[] weights = new int[blockPartsCount];
        int i = 0;
        while (i < blockPartsCount) {
            SplitFormBlockPart block = blockParts.get(i);
            Composite blockComposite = new Composite((Composite)form, 0);
            context.adapt((Control)blockComposite);
            SapphireRenderingContext blockContext = new SapphireRenderingContext(this, context, blockComposite);
            int rightMargin = i < blockPartsCount - 1 && this.getOrientation() == Orientation.HORIZONTAL ? 4 : 0;
            int bottomMargin = i < blockPartsCount - 1 && this.getOrientation() == Orientation.VERTICAL ? 1 : 0;
            int topMargin = i > 0 && this.getOrientation() == Orientation.VERTICAL ? 1 : 0;
            blockComposite.setLayout((Layout)GridLayoutUtil.glayout(2, 0, rightMargin, topMargin, bottomMargin));
            block.render(blockContext);
            weights[i] = block.getWeight();
            ++i;
        }
        form.setWeights(weights);
    }
}

