/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.renderers.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.modeling.BindingImpl;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.XmlValueBindingImpl;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionHandlerFilter;
import org.eclipse.sapphire.ui.SapphireActionSystem;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.internal.binding.AbstractBinding;
import org.eclipse.sapphire.ui.renderers.swt.ListPropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRendererFactory;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.swt.renderer.SapphireKeyboardActionPresentation;
import org.eclipse.sapphire.ui.swt.renderer.SapphireToolBarActionPresentation;
import org.eclipse.sapphire.ui.swt.renderer.TextOverlayPainter;
import org.eclipse.sapphire.ui.swt.renderer.internal.formtext.SapphireFormText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;

public final class CompactListPropertyEditorRenderer
extends ListPropertyEditorRenderer {
    public static final String DATA_SELECTION_PROVIDER = "selection.provider";
    private Runnable refreshOperation;
    ValueProperty memberProperty;
    private Composite mainComposite;
    private Composite textComposite;
    private List<TextBinding> textBindings = new ArrayList<TextBinding>();
    private SapphireFormText addText;
    private HyperlinkAdapter addTextHyperlinkAdapter;
    private Label label;

    public CompactListPropertyEditorRenderer(SapphireRenderingContext context, SapphirePropertyEditor part) {
        super(context, part);
    }

    protected void createContents(Composite parent) {
        ModelProperty prop;
        SapphirePropertyEditor part = this.getPart();
        ListProperty property = (ListProperty)part.getProperty();
        List allMemberProperties = property.getType().getProperties();
        if (allMemberProperties.size() == 1) {
            prop = (ModelProperty)allMemberProperties.get(0);
            if (!(prop instanceof ValueProperty)) {
                throw new IllegalStateException();
            }
        } else {
            throw new IllegalStateException();
        }
        this.memberProperty = (ValueProperty)prop;
        this.mainComposite = this.createMainComposite(parent);
        this.mainComposite.setLayout((Layout)GridLayoutUtil.glayout(2, 0, 0, 2, 2));
        this.addControls(1);
        this.refreshOperation = new Runnable(){
            boolean running = false;

            public void run() {
                if (CompactListPropertyEditorRenderer.this.mainComposite.isDisposed()) {
                    return;
                }
                if (this.running) {
                    return;
                }
                this.running = true;
                try {
                    CompactListPropertyEditorRenderer.this.refreshControls();
                }
                finally {
                    this.running = false;
                }
            }
        };
        this.binding = new AbstractBinding(this.getPart(), this.context, (Control)this.mainComposite){

            protected void doUpdateModel() {
            }

            protected void doUpdateTarget() {
                CompactListPropertyEditorRenderer.this.refreshOperation.run();
            }
        };
    }

    private void addControls(int count) {
        if (this.addText != null && this.addTextHyperlinkAdapter != null) {
            this.addText.removeHyperlinkListener((IHyperlinkListener)this.addTextHyperlinkAdapter);
        }
        int i = 0;
        while (i < this.textBindings.size()) {
            this.textBindings.get(i).removeListener();
            ++i;
        }
        Control[] controlArray = this.mainComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        this.textBindings.clear();
        this.textComposite = new Composite(this.mainComposite, 0);
        this.textComposite.setLayoutData((Object)GridLayoutUtil.gdhspan(GridLayoutUtil.gdfill(), 2));
        this.textComposite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glayout(3, 0, 0), 2, 4));
        this.addControl((Control)this.textComposite);
        i = 0;
        while (i < count) {
            ProxyResource resource = new ProxyResource();
            IModelElement proxyElement = this.memberProperty.getModelElementType().instantiate((IModelParticle)this.getPart().getLocalModelElement(), this.getPart().getProperty(), (Resource)resource);
            resource.init(proxyElement, this.memberProperty);
            SapphirePropertyEditor editor = this.getPart().getChildPropertyEditor(proxyElement, (ModelProperty)this.memberProperty);
            PropertyEditorAssistDecorator decorator = this.addDecorator(editor);
            Text text = new Text(this.textComposite, 2048);
            text.setLayoutData((Object)GridLayoutUtil.gdhindent(GridLayoutUtil.gdwhint(GridLayoutUtil.gdhfill(), 150), 0));
            TextBinding binding = new TextBinding(text, resource);
            binding.setDecorator(decorator);
            this.textBindings.add(binding);
            this.addControl((Control)text);
            this.addToolbar(binding, editor);
            decorator.addEditorControl((Control)text);
            decorator.addEditorControl((Control)binding.getToolbar());
            ++i;
        }
        this.addText = new SapphireFormText(this.mainComposite, 0);
        this.addText.setLayoutData(GridLayoutUtil.gdhindent(GridLayoutUtil.gdvalign(GridLayoutUtil.gdhfill(), 0x1000000), 10));
        this.context.adapt((Control)this.addText);
        this.addControl((Control)this.addText);
        StringBuilder buf = new StringBuilder();
        buf.append("<form><p vspace=\"false\"><a href=\"action\" nowrap=\"true\">");
        buf.append("Add ");
        ListProperty listProperty = (ListProperty)this.getPart().getProperty();
        buf.append(listProperty.getType().getLabel(false, CapitalizationType.NO_CAPS, false));
        buf.append("</a></p></form>");
        this.addText.setText(buf.toString(), true, false);
        if (this.addTextHyperlinkAdapter == null) {
            this.addTextHyperlinkAdapter = new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent event) {
                    CompactListPropertyEditorRenderer.this.addActivated();
                    CompactListPropertyEditorRenderer.this.refreshDeleteActions();
                }
            };
        }
        this.addText.addHyperlinkListener((IHyperlinkListener)this.addTextHyperlinkAdapter);
    }

    private void addToolbar(TextBinding binding, SapphirePropertyEditor editor) {
        SapphireActionGroup parentActions = new SapphireActionGroup(this.getPart(), this.getPart().getActionContext());
        final SapphireAction deleteAction = parentActions.getAction("Sapphire.Delete");
        deleteAction.setGroup(null);
        final DeleteActionHandler deleteActionHandler = new DeleteActionHandler(binding);
        deleteActionHandler.init(deleteAction, null);
        deleteAction.addHandler(deleteActionHandler);
        SapphireActionGroup actions = editor.getActions();
        actions.addAction(deleteAction);
        SapphireActionHandler jumpActionHandler = actions.getAction("Sapphire.Jump").getFirstActiveHandler();
        this.addJumpOverlay(jumpActionHandler, binding);
        SapphireActionHandlerFilter assistFilter = SapphireActionSystem.createFilterByActionId("Sapphire.Assist");
        SapphireActionHandlerFilter jumpFilter = SapphireActionSystem.createFilterByActionId("Sapphire.Jump");
        actions.addFilter(assistFilter);
        actions.addFilter(jumpFilter);
        SapphireActionPresentationManager actionPresentationManager = new SapphireActionPresentationManager(this.context, actions);
        SapphireToolBarActionPresentation toolBarActionsPresentation = new SapphireToolBarActionPresentation(actionPresentationManager);
        final SapphireKeyboardActionPresentation actionPresentationKeyboard = new SapphireKeyboardActionPresentation(actionPresentationManager);
        binding.setActionPresentationKeyboard(actionPresentationKeyboard);
        ToolBar toolbar = new ToolBar(this.textComposite, 0x800100);
        toolbar.setLayoutData((Object)GridLayoutUtil.gdhindent(GridLayoutUtil.gdvfill(), 2));
        toolBarActionsPresentation.setToolBar(toolbar);
        toolBarActionsPresentation.render();
        this.context.adapt((Control)toolbar);
        this.addControl((Control)toolbar);
        toolbar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                deleteAction.removeHandler(deleteActionHandler);
                actionPresentationKeyboard.dispose();
            }
        });
        binding.setToolbar(toolbar);
        binding.setDeleteActionHandler(deleteActionHandler);
        actions.removeFilter(assistFilter);
        actions.removeFilter(jumpFilter);
    }

    private void addJumpOverlay(final SapphireActionHandler jumpActionHandler, final TextBinding binding) {
        TextOverlayPainter.Controller textOverlayPainterController = jumpActionHandler != null ? new TextOverlayPainter.Controller(){

            public boolean isHyperlinkEnabled() {
                return jumpActionHandler.isEnabled();
            }

            public void handleHyperlinkEvent() {
                jumpActionHandler.execute(CompactListPropertyEditorRenderer.this.context);
            }

            public String getDefaultText() {
                ProxyResource resource = binding.getResource();
                IModelElement element = resource.getModelElement();
                return element == null ? null : element.read(resource.getValueProperty()).getDefaultText();
            }
        } : new TextOverlayPainter.Controller(){

            public String getDefaultText() {
                ProxyResource resource = binding.getResource();
                IModelElement element = resource.getModelElement();
                return element == null ? null : element.read(resource.getValueProperty()).getDefaultText();
            }
        };
        TextOverlayPainter.install(binding.getText(), textOverlayPainterController);
    }

    private PropertyEditorAssistDecorator addDecorator(SapphirePropertyEditor editor) {
        PropertyEditorAssistDecorator decorator = new PropertyEditorAssistDecorator(editor, this.context, this.textComposite);
        decorator.control().setLayoutData((Object)GridLayoutUtil.gdvindent(GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 128), 2));
        return decorator;
    }

    private void addActivated() {
        ProxyResource resource = new ProxyResource();
        IModelElement proxyElement = this.memberProperty.getModelElementType().instantiate((IModelParticle)this.getPart().getLocalModelElement(), this.getPart().getProperty(), (Resource)resource);
        resource.init(proxyElement, this.memberProperty);
        SapphirePropertyEditor editor = this.getPart().getChildPropertyEditor(proxyElement, (ModelProperty)this.memberProperty);
        PropertyEditorAssistDecorator decorator = this.addDecorator(editor);
        Text text = new Text(this.textComposite, 2048);
        text.setLayoutData((Object)GridLayoutUtil.gdwhint(GridLayoutUtil.gdhfill(), 150));
        TextBinding binding = new TextBinding(text, resource);
        binding.setDecorator(decorator);
        this.textBindings.add(binding);
        this.addControl((Control)text);
        this.addToolbar(binding, editor);
        decorator.addEditorControl((Control)text);
        decorator.addEditorControl((Control)binding.getToolbar());
        this.context.layout();
        text.setFocus();
    }

    private void refreshControls() {
        if (!this.needsRefresh()) {
            this.refreshDeleteActions();
            return;
        }
        ModelElementList<IModelElement> list = this.getList();
        if (list.size() != this.textBindings.size()) {
            this.addControls(Math.max(1, list.size()));
            this.context.layout();
        }
        int i = 0;
        while (i < list.size()) {
            IModelElement elem = list.get(i);
            this.textBindings.get(i).refreshModelElement(elem);
            ++i;
        }
        if (list.size() == 0) {
            this.textBindings.get(0).refreshModelElement(null);
        }
        this.refreshDeleteActions();
    }

    private void refreshDeleteActions() {
        int size = this.textBindings.size();
        int i = 0;
        while (i < size) {
            TextBinding binding = this.textBindings.get(i);
            if (i == 0 && size == 1) {
                binding.getDeleteActionHandler().refreshEnablement();
            } else {
                binding.getDeleteActionHandler().setEnabled(true);
            }
            ++i;
        }
    }

    private boolean needsRefresh() {
        for (TextBinding binding : this.textBindings) {
            if (!binding.isModifying()) continue;
            return false;
        }
        return true;
    }

    void deleteBinding(TextBinding binding) {
        IModelElement elem = binding.getModelElement();
        Text text = binding.getText();
        ToolBar toolbar = binding.getToolbar();
        PropertyEditorAssistDecorator decorator = binding.getDecorator();
        binding.setModifying(true);
        if (elem != null) {
            this.getList().remove((Object)elem);
        }
        binding.setModifying(false);
        if (this.textBindings.size() > 1) {
            binding.removeListener();
            this.textBindings.remove(binding);
            text.dispose();
            toolbar.dispose();
            Label control = decorator.control();
            decorator.removeEditorControl((Control)control);
            control.dispose();
            this.context.layout();
        } else {
            binding.refreshModelElement(null);
        }
        this.refreshDeleteActions();
    }

    public void insertEmpty(TextBinding binding) {
        for (TextBinding b : this.textBindings) {
            if (b == binding) {
                return;
            }
            if (b.getModelElement() != null) continue;
            IModelElement newElement = this.getList().addNewElement();
            b.setModelElement(newElement);
        }
    }

    public static final boolean equals(Object o1, Object o2) {
        boolean objectsAreEqual = false;
        if (o1 == o2) {
            objectsAreEqual = true;
        } else if (o1 != null && o2 != null) {
            objectsAreEqual = o1.equals(o2);
        }
        return objectsAreEqual;
    }

    public final PropertyEditorAssistDecorator getDecorator() {
        return this.decorator;
    }

    public final void setDecorator(PropertyEditorAssistDecorator decorator) {
        this.decorator = decorator;
    }

    protected void handlePropertyChangedEvent() {
        super.handlePropertyChangedEvent();
        this.refreshOperation.run();
    }

    protected void handleListElementChangedEvent(ModelPropertyChangeEvent event) {
        super.handleListElementChangedEvent(event);
        this.refreshOperation.run();
    }

    protected void handleFocusReceivedEvent() {
        this.textBindings.get(0).getText().setFocus();
    }

    private final class DeleteActionHandler
    extends SapphireActionHandler {
        TextBinding binding;

        public DeleteActionHandler(TextBinding binding) {
            this.binding = binding;
        }

        protected Object run(SapphireRenderingContext context) {
            CompactListPropertyEditorRenderer.this.deleteBinding(this.binding);
            return null;
        }

        public final void refreshEnablement() {
            this.setEnabled(this.binding.getModelElement() != null);
        }
    }

    public static final class Factory
    extends PropertyEditorRendererFactory {
        public boolean isApplicableTo(SapphirePropertyEditor propertyEditorDefinition) {
            return propertyEditorDefinition.getProperty() instanceof ListProperty;
        }

        public PropertyEditorRenderer create(SapphireRenderingContext context, SapphirePropertyEditor part) {
            return new CompactListPropertyEditorRenderer(context, part);
        }
    }

    private final class ProxyResource
    extends XmlResource {
        private IModelElement proxyElement;
        private IModelElement actualElement;
        private ValueProperty actualProperty;
        private String value;

        public ProxyResource() {
            super((XmlResource)CompactListPropertyEditorRenderer.this.getPart().getModelElement().resource());
        }

        public void init(IModelElement proxyElement, ValueProperty actualProperty) {
            this.proxyElement = proxyElement;
            this.actualProperty = actualProperty;
        }

        protected BindingImpl createBinding(ModelProperty property) {
            if (property instanceof ValueProperty) {
                return new ProxyBinding();
            }
            return null;
        }

        public void setModelElement(IModelElement element) {
            this.actualElement = element;
            this.value = element != null ? element.read(this.actualProperty).getText() : null;
            this.proxyElement.refresh();
        }

        public IModelElement getModelElement() {
            return this.actualElement;
        }

        public ValueProperty getValueProperty() {
            return this.actualProperty;
        }

        private IModelElement getActualElement(boolean create) {
            if (create && this.actualElement == null) {
                IModelElement element = CompactListPropertyEditorRenderer.this.getList().addNewElement();
                this.setModelElement(element);
            }
            return this.actualElement;
        }

        public XmlElement getXmlElement(boolean createIfNecessary) {
            IModelElement element = this.getActualElement(true);
            if (element != null) {
                return ((XmlResource)element.resource()).getXmlElement();
            }
            return null;
        }

        private final class ProxyBinding
        extends XmlValueBindingImpl {
            private ProxyBinding() {
            }

            public String read() {
                return ProxyResource.this.value;
            }

            public void write(String value) {
                ProxyResource.this.value = value;
                IModelElement element = ProxyResource.this.getActualElement(true);
                ValueProperty property = ProxyResource.this.getValueProperty();
                element.write(property, (Object)value);
            }
        }
    }

    private final class TextBinding
    implements ModifyListener {
        private Text text;
        private ProxyResource resource;
        private ToolBar toolbar;
        private DeleteActionHandler deleteActionHandler;
        private PropertyEditorAssistDecorator decorator;
        private SapphireKeyboardActionPresentation actionPresentationKeyboard;
        private boolean modifying = false;

        public TextBinding(Text text, ProxyResource resource) {
            this.text = text;
            this.text.addModifyListener((ModifyListener)this);
            this.resource = resource;
        }

        public void removeListener() {
            this.text.removeModifyListener((ModifyListener)this);
            this.actionPresentationKeyboard.dispose();
        }

        public Text getText() {
            return this.text;
        }

        public ProxyResource getResource() {
            return this.resource;
        }

        public void refreshModelElement(IModelElement element) {
            this.setModelElement(element);
            String value = element != null ? element.read(this.resource.getValueProperty()).getText() : null;
            String string = value = value == null ? "" : value;
            if (!CompactListPropertyEditorRenderer.equals(value, this.text.getText())) {
                this.text.setText(value);
            }
        }

        public void setModelElement(IModelElement element) {
            this.resource.setModelElement(element);
        }

        public IModelElement getModelElement() {
            return this.resource.getModelElement();
        }

        public boolean isModifying() {
            return this.modifying;
        }

        public void setModifying(boolean modifying) {
            this.modifying = modifying;
        }

        public ToolBar getToolbar() {
            return this.toolbar;
        }

        public void setToolbar(ToolBar toolbar) {
            this.toolbar = toolbar;
        }

        public void setActionPresentationKeyboard(SapphireKeyboardActionPresentation actionPresentationKeyboard) {
            this.actionPresentationKeyboard = actionPresentationKeyboard;
            this.actionPresentationKeyboard.attach((Control)this.text);
            this.actionPresentationKeyboard.render();
        }

        public DeleteActionHandler getDeleteActionHandler() {
            return this.deleteActionHandler;
        }

        public void setDeleteActionHandler(DeleteActionHandler deleteActionHandler) {
            this.deleteActionHandler = deleteActionHandler;
        }

        public PropertyEditorAssistDecorator getDecorator() {
            return this.decorator;
        }

        public void setDecorator(PropertyEditorAssistDecorator decorator) {
            this.decorator = decorator;
        }

        public void modifyText(ModifyEvent e) {
            if (!this.text.isDisposed() && (this.text.getStyle() & 8) == 0) {
                IModelElement element = this.resource.getModelElement();
                String value = this.text.getText();
                if (value.length() != 0 || !e.getSource().equals(this.text) || element != null) {
                    this.modifying = true;
                    boolean createNew = false;
                    if (element == null) {
                        CompactListPropertyEditorRenderer.this.insertEmpty(this);
                        IModelElement newElement = CompactListPropertyEditorRenderer.this.getList().addNewElement();
                        this.setModelElement(newElement);
                        createNew = true;
                    }
                    this.resource.element().write(this.resource.getValueProperty(), (Object)value);
                    if (createNew) {
                        this.text.setSelection(value.length(), value.length());
                    }
                    this.modifying = false;
                }
            }
        }
    }
}

