/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.renderer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.localization.LabelTransformer;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.swt.renderer.SapphireActionPresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphireActionPresentationManager {
    private String label = Resources.defaultLabel;
    private final SapphireRenderingContext context;
    private final SapphireActionGroup actions;
    private final List<SapphireActionPresentation> presentations;
    private final List<SapphireActionPresentation> presentationsReadOnly;

    public SapphireActionPresentationManager(SapphireRenderingContext context, SapphireActionGroup actions) {
        this.context = context;
        this.actions = actions;
        this.presentations = new ArrayList<SapphireActionPresentation>();
        this.presentationsReadOnly = Collections.unmodifiableList(this.presentations);
    }

    public String getLabel() {
        return LabelTransformer.transform((String)this.label, (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)false);
    }

    public void setLabel(String label) {
        this.label = label == null ? Resources.defaultLabel : label;
    }

    public List<SapphireActionPresentation> getPresentations() {
        return this.presentationsReadOnly;
    }

    void addPresentation(SapphireActionPresentation presentation) {
        this.presentations.add(presentation);
    }

    public SapphireRenderingContext getContext() {
        return this.context;
    }

    public List<SapphireAction> getActions() {
        return this.actions.getActions();
    }

    public void dispose() {
        for (SapphireActionPresentation presentation : this.presentations) {
            try {
                presentation.dispose();
            }
            catch (Exception e) {
                SapphireUiFrameworkPlugin.log(e);
            }
        }
    }

    private static final class Resources
    extends NLS {
        public static String defaultLabel;

        static {
            Resources.initializeMessages((String)SapphireActionPresentationManager.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

