/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.util.SortedSet;
import org.eclipse.sapphire.modeling.ElementBindingImpl;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.PossibleTypesService;
import org.eclipse.sapphire.services.ValidationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelElementHandle<T extends IModelElement> {
    private final IModelElement parent;
    private final ElementProperty property;
    private final PossibleTypesService possibleTypesService;
    private final ElementBindingImpl binding;
    private final ModelPropertyListener listener;
    private T element;
    private Status validationStateLocal;
    private Status validationStateFull;

    public ModelElementHandle(IModelElement parent, ElementProperty property) {
        this.parent = parent;
        this.property = property;
        this.possibleTypesService = parent.service(property, PossibleTypesService.class);
        this.binding = parent.resource().binding(property);
        this.listener = new ModelPropertyListener(){

            public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                ModelElementHandle.this.refresh();
            }
        };
    }

    public void init() {
        this.refreshInternal();
    }

    public IModelElement root() {
        return (IModelElement)this.parent.root();
    }

    public IModelElement parent() {
        return this.parent;
    }

    public T element() {
        return this.element(false);
    }

    public T element(boolean createIfNecessary) {
        if (createIfNecessary) {
            SortedSet<ModelElementType> possible = this.possibleTypesService.types();
            if (possible.size() > 1) {
                throw new IllegalArgumentException();
            }
            return this.element(true, possible.first());
        }
        return this.element(false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T element(boolean createIfNecessary, ModelElementType type) {
        SortedSet<ModelElementType> possible = this.possibleTypesService.types();
        if (type != null && !possible.contains(type)) {
            throw new IllegalArgumentException();
        }
        boolean changed = false;
        if (createIfNecessary) {
            ModelElementType t = type;
            if (t == null) {
                if (possible.size() > 1) {
                    throw new IllegalArgumentException();
                }
                t = possible.first();
            }
            ModelElementHandle modelElementHandle = this;
            synchronized (modelElementHandle) {
                if (this.element == null) {
                    this.refresh();
                }
                if (this.element != null && this.element.getModelElementType() != t) {
                    this.removeInternal();
                }
                if (this.element == null) {
                    Resource resource = this.binding.create(t);
                    this.element = t.instantiate(this.parent, this.property, resource);
                    for (ModelProperty property : t.getProperties()) {
                        this.element.addListener(this.listener, property.getName());
                    }
                    this.refreshValidationState();
                    changed = true;
                }
            }
        }
        ModelElementHandle modelElementHandle = this;
        synchronized (modelElementHandle) {
            if (this.element != null && type != null && this.element.getModelElementType() != type) {
                throw new IllegalArgumentException();
            }
        }
        if (changed) {
            this.parent.notifyPropertyChangeListeners(this.property);
        }
        return this.element;
    }

    public Status validate() {
        return this.validate(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status validate(boolean includeChildValidation) {
        ModelElementHandle modelElementHandle = this;
        synchronized (modelElementHandle) {
            return includeChildValidation ? this.validationStateFull : this.validationStateLocal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enabled() {
        ModelElementHandle modelElementHandle = this;
        synchronized (modelElementHandle) {
            return this.parent.isPropertyEnabled(this.property);
        }
    }

    public void remove() {
        boolean changed = this.removeInternal();
        if (changed) {
            this.parent.notifyPropertyChangeListeners(this.property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeInternal() {
        ModelElementHandle modelElementHandle = this;
        synchronized (modelElementHandle) {
            boolean changed = false;
            if (this.element != null) {
                this.binding.remove();
                changed = this.refreshInternal();
            }
            return changed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removable() {
        ModelElementHandle modelElementHandle = this;
        synchronized (modelElementHandle) {
            return this.binding.removable();
        }
    }

    public boolean refresh() {
        boolean changed = this.refreshInternal();
        if (changed) {
            this.parent.notifyPropertyChangeListeners(this.property);
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean refreshInternal() {
        ModelElementHandle modelElementHandle = this;
        synchronized (modelElementHandle) {
            boolean changed = false;
            Resource oldResource = this.element == null ? null : this.element.resource();
            Resource newResource = this.binding.read();
            if (newResource != oldResource) {
                if (newResource == null) {
                    this.element = null;
                } else {
                    ModelElementType type = this.binding.type(newResource);
                    this.element = type.instantiate(this.parent, this.property, newResource);
                }
                changed = true;
            }
            changed = this.refreshValidationState() || changed;
            return changed;
        }
    }

    private boolean refreshValidationState() {
        Status oldValidationStateFull = this.validationStateFull;
        Status.CompositeStatusFactory newValidationStateLocalFactory = Status.factoryForComposite();
        Status.CompositeStatusFactory newValidationStateFullFactory = Status.factoryForComposite();
        if (this.enabled()) {
            for (ValidationService svc : this.parent().services(this.property, ValidationService.class)) {
                Status st = null;
                try {
                    st = svc.validate();
                }
                catch (Exception e) {
                    LoggingService.log(e);
                }
                if (st == null) continue;
                newValidationStateLocalFactory.merge(st);
                newValidationStateFullFactory.merge(st);
            }
            if (this.element != null) {
                newValidationStateFullFactory.merge(this.element.validate());
            }
        }
        Status newValidationStateLocal = newValidationStateLocalFactory.create();
        Status newValidationStateFull = newValidationStateFullFactory.create();
        if (!newValidationStateFull.equals(oldValidationStateFull)) {
            this.validationStateLocal = newValidationStateLocal;
            this.validationStateFull = newValidationStateFull;
            return oldValidationStateFull != null;
        }
        return false;
    }
}

