/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ListenerContext;
import org.eclipse.sapphire.services.ServiceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Service {
    private ServiceContext context;
    private Map<String, String> params;
    private final ListenerContext listeners = new ListenerContext();

    public final void init(ServiceContext context, Map<String, String> params) {
        this.context = context;
        int paramsCount = params.size();
        if (paramsCount == 0) {
            this.params = Collections.emptyMap();
        } else if (paramsCount == 1) {
            Map.Entry<String, String> entry = params.entrySet().iterator().next();
            this.params = Collections.singletonMap(entry.getKey(), entry.getValue());
        } else {
            this.params = new HashMap<String, String>(params);
            this.params = Collections.unmodifiableMap(this.params);
        }
        this.init();
    }

    protected void init() {
    }

    protected final ServiceContext context() {
        return this.context;
    }

    protected final <T> T context(Class<T> type) {
        return this.context.find(type);
    }

    protected final Map<String, String> params() {
        return this.params;
    }

    protected final String param(String name) {
        return this.params.get(name);
    }

    public final void attach(Listener listener) {
        this.listeners.attach(listener);
    }

    public final void detach(Listener listener) {
        this.listeners.detach(listener);
    }

    protected final void broadcast(Event event) {
        this.listeners.broadcast(event);
    }

    protected final void broadcast() {
        this.listeners.broadcast();
    }

    public void dispose() {
    }
}

