/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.services.EnablementService;
import org.eclipse.sapphire.services.EnablementServiceData;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;

public final class ParentBasedEnablementService
extends EnablementService {
    private IModelElement parentElement;
    private ModelProperty parentProperty;
    private ModelPropertyListener listener;

    protected void initEnablementService() {
        IModelElement element = this.context(IModelElement.class);
        IModelParticle parent = element.parent();
        if (!(parent instanceof IModelElement)) {
            parent = parent.parent();
        }
        this.parentElement = (IModelElement)parent;
        this.parentProperty = element.getParentProperty();
        this.listener = new ModelPropertyListener(){

            public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                ParentBasedEnablementService.this.refresh();
            }
        };
        this.parentElement.addListener(this.listener, this.parentProperty.getName());
    }

    public EnablementServiceData compute() {
        return new EnablementServiceData(this.parentElement.isPropertyEnabled(this.parentProperty));
    }

    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            this.parentElement.removeListener(this.listener, this.parentProperty.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            return context.find(IModelElement.class).getParentProperty() != null;
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new ParentBasedEnablementService();
        }
    }
}

