/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.List;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.services.DocumentationService;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;
import org.eclipse.sapphire.services.internal.StandardDocumentationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StandardElementDocumentationService
extends StandardDocumentationService {
    @Override
    protected void initStandardDocumentationService(StringBuilder content, List<DocumentationService.Topic> topics) {
        ModelElementType type = this.context(ModelElementType.class);
        Documentation docAnnotation = type.getAnnotation(Documentation.class, true);
        if (docAnnotation != null) {
            LocalizationService localization = type.getLocalizationService();
            String docAnnotationContent = localization.text(docAnnotation.content().trim(), CapitalizationType.NO_CAPS, false);
            if (docAnnotationContent.length() > 0) {
                content.append(docAnnotationContent);
            }
            topics.addAll(StandardElementDocumentationService.convert(docAnnotation.topics(), localization));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            return context.find(ModelElementType.class).hasAnnotation(Documentation.class);
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new StandardElementDocumentationService();
        }
    }
}

