/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.services.PossibleTypesService;
import org.eclipse.sapphire.services.PossibleTypesServiceData;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;

public final class StandardPossibleTypesService
extends PossibleTypesService {
    private Set<ModelElementType> possible;

    protected void initPossibleTypesService() {
        ModelProperty property = this.context(ModelProperty.class);
        ArrayList<Class> possible = new ArrayList<Class>();
        Type typeAnnotation = property.getAnnotation(Type.class);
        if (property instanceof ElementProperty || property instanceof ListProperty) {
            if (typeAnnotation != null) {
                if (typeAnnotation.possible().length == 0) {
                    possible.add(typeAnnotation.base());
                } else {
                    Class<?>[] classArray = typeAnnotation.possible();
                    int n = classArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Class cl = classArray[n2];
                        possible.add(cl);
                        ++n2;
                    }
                }
            }
            if (possible.size() == 1) {
                this.possible = Collections.singleton(ModelElementType.getModelElementType((Class)possible.get(0)));
            } else {
                this.possible = new HashSet<ModelElementType>();
                for (Class cl : possible) {
                    this.possible.add(ModelElementType.getModelElementType(cl));
                }
            }
        }
    }

    protected PossibleTypesServiceData compute() {
        return new PossibleTypesServiceData(this.possible);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            return true;
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new StandardPossibleTypesService();
        }
    }
}

