/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionSystemPart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireActionHandlerDef;
import org.eclipse.sapphire.ui.def.SapphireActionType;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;

public abstract class SapphireActionHandler
extends SapphireActionSystemPart {
    private SapphireAction action;

    public void init(SapphireAction action, ISapphireActionHandlerDef def) {
        this.action = action;
        super.init(def);
        if (this.getId() == null) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.getClass().getName());
            buf.append('#');
            buf.append(System.identityHashCode(this));
            this.setId(buf.toString());
        }
        if (this.getLabel() == null) {
            this.setLabel(this.action.getLabel());
        }
    }

    protected final FunctionContext initFunctionContext() {
        ISapphirePart part = this.getPart();
        return new ModelElementFunctionContext(part.getLocalModelElement(), (LocalizationService)part.getDefinition().adapt(LocalizationService.class));
    }

    public final SapphireAction getAction() {
        return this.action;
    }

    public final ISapphirePart getPart() {
        return this.action.getPart();
    }

    public final String getContext() {
        return this.action.getContext();
    }

    public IModelElement getModelElement() {
        return this.getPart().getModelElement();
    }

    public final void execute(SapphireRenderingContext context) {
        if (this.getAction().getType() == SapphireActionType.TOGGLE) {
            this.setChecked(!this.isChecked());
        }
        this.broadcast(new PreExecuteEvent());
        Object result = null;
        try {
            result = this.run(context);
        }
        catch (Exception e) {
            SapphireUiFrameworkPlugin.log(e);
        }
        this.broadcast(new PostExecuteEvent(result));
    }

    protected abstract Object run(SapphireRenderingContext var1);

    public static class PostExecuteEvent
    extends Event {
        private final Object result;

        public PostExecuteEvent(Object result) {
            this.result = result;
        }

        public Object getResult() {
            return this.result;
        }
    }

    public static class PreExecuteEvent
    extends Event {
    }
}

