/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.assist.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireImageCache;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.ActionsSectionAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.FactsAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.InfoSectionAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.ProblemsAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.ProblemsSectionAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDialog;
import org.eclipse.sapphire.ui.assist.internal.ResetActionsAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.RestoreInitialValueActionsAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.ShowInSourceActionAssistContributor;
import org.eclipse.sapphire.ui.def.ISapphirePartDef;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.renderers.swt.SwtRendererUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public final class PropertyEditorAssistDecorator {
    private static final List<PropertyEditorAssistContributor> SYSTEM_CONTRIBUTORS = new ArrayList<PropertyEditorAssistContributor>();
    private static final ImageDescriptor IMG_ASSIST;
    private static final ImageDescriptor IMG_ASSIST_FAINT;
    private static final ImageDescriptor IMG_ASSIST_CLEAR;
    private final SapphirePart part;
    private IModelElement element;
    private final ModelProperty property;
    private final SapphireRenderingContext context;
    private final Label control;
    private Control primary;
    private final Collection<String> contributorsToSuppress;
    private final Collection<Class<?>> additionalContributors;
    private PropertyEditorAssistContext assistContext;
    private Status problem;
    private boolean mouseOverEditorControl;
    private EditorControlMouseTrackListener mouseTrackListener;
    private ModelPropertyListener modelPropertyListener;

    static {
        SYSTEM_CONTRIBUTORS.add(new InfoSectionAssistContributor());
        SYSTEM_CONTRIBUTORS.add(new FactsAssistContributor());
        SYSTEM_CONTRIBUTORS.add(new ProblemsSectionAssistContributor());
        SYSTEM_CONTRIBUTORS.add(new ActionsSectionAssistContributor());
        SYSTEM_CONTRIBUTORS.add(new ResetActionsAssistContributor());
        SYSTEM_CONTRIBUTORS.add(new RestoreInitialValueActionsAssistContributor());
        SYSTEM_CONTRIBUTORS.add(new ShowInSourceActionAssistContributor());
        IMG_ASSIST = SwtRendererUtil.createImageDescriptor(PropertyEditorAssistContext.class, "Assist.png");
        IMG_ASSIST_FAINT = SwtRendererUtil.createImageDescriptor(PropertyEditorAssistContext.class, "AssistFaint.png");
        IMG_ASSIST_CLEAR = SwtRendererUtil.createImageDescriptor(PropertyEditorAssistContext.class, "AssistClear.png");
    }

    public PropertyEditorAssistDecorator(SapphirePropertyEditor part, SapphireRenderingContext context, Composite parent) {
        this(part, part.getLocalModelElement(), part.getProperty(), context, parent);
    }

    public PropertyEditorAssistDecorator(SapphirePart part, IModelElement element, ModelProperty property, SapphireRenderingContext context, Composite parent) {
        this.part = part;
        this.property = property;
        this.context = context;
        this.mouseOverEditorControl = false;
        this.mouseTrackListener = new EditorControlMouseTrackListener();
        ISapphirePartDef def = this.part.getDefinition();
        this.contributorsToSuppress = new ArrayList<String>();
        String contributorsToSuppressStr = def.getHint("suppress.assist.contributors");
        if (contributorsToSuppressStr != null) {
            String[] stringArray = contributorsToSuppressStr.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                this.contributorsToSuppress.add(segment.trim());
                ++n2;
            }
        }
        this.additionalContributors = new ArrayList();
        String additionalContributorsStr = def.getHint("assist.contributors");
        if (additionalContributorsStr != null) {
            ISapphireUiDef rootdef = (ISapphireUiDef)def.nearest(ISapphireUiDef.class);
            String[] stringArray = additionalContributorsStr.split(",");
            int n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                String segment = stringArray[n3];
                Class<?> cl = rootdef.resolveClass(segment.trim());
                if (cl != null) {
                    this.additionalContributors.add(cl);
                }
                ++n3;
            }
        }
        this.modelPropertyListener = new ModelPropertyListener(){

            public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        PropertyEditorAssistDecorator.this.refresh();
                    }
                });
            }
        };
        this.element(element);
        SapphireActionGroup actions = part.getActions();
        final SapphireAction assistAction = actions.getAction("Sapphire.Assist");
        final SapphireActionHandler assistActionHandler = new SapphireActionHandler(){

            protected Object run(SapphireRenderingContext context) {
                PropertyEditorAssistDecorator.this.openAssistDialog();
                return null;
            }
        };
        assistActionHandler.init(assistAction, null);
        assistAction.addHandler(assistActionHandler);
        this.control = new Label(parent, 0);
        this.context.adapt((Control)this.control);
        this.control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                PropertyEditorAssistDecorator.this.openAssistDialog();
            }
        });
        this.control.addMouseTrackListener((MouseTrackListener)new EditorControlMouseTrackListener(){

            public void mouseEnter(MouseEvent event) {
                super.mouseEnter(event);
                PropertyEditorAssistDecorator.this.refreshImageAndCursor();
            }

            public void mouseHover(MouseEvent event) {
            }
        });
        this.control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                PropertyEditorAssistDecorator.this.element(null);
                assistAction.removeHandler(assistActionHandler);
            }
        });
        this.refresh();
    }

    public Label control() {
        return this.control;
    }

    public SapphireRenderingContext context() {
        return this.context;
    }

    public Shell shell() {
        return this.context.getShell();
    }

    public SapphirePart part() {
        return this.part;
    }

    public IModelElement element() {
        return this.element;
    }

    public void element(IModelElement element) {
        if (this.element != null) {
            this.element.removeListener(this.modelPropertyListener, this.property.getName());
        }
        this.element = element;
        if (this.element != null) {
            this.element.addListener(this.modelPropertyListener, this.property.getName());
        }
    }

    public ModelProperty property() {
        return this.property;
    }

    public void addEditorControl(Control control) {
        this.addEditorControl(control, false);
    }

    public void addEditorControl(Control control, boolean primary) {
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.addEditorControl(child);
                ++n2;
            }
        }
        control.addMouseTrackListener((MouseTrackListener)this.mouseTrackListener);
        if (primary) {
            this.primary = control;
        }
    }

    public void removeEditorControl(Control control) {
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.removeEditorControl(child);
                ++n2;
            }
        }
        control.removeMouseTrackListener((MouseTrackListener)this.mouseTrackListener);
        if (this.primary == control) {
            this.primary = null;
        }
    }

    private void openAssistDialog() {
        if (this.assistContext != null && !this.assistContext.isEmpty()) {
            Point position;
            Rectangle primaryControlBounds;
            Rectangle decoratorControlBounds = this.control.getBounds();
            Rectangle rectangle = primaryControlBounds = this.primary == null ? null : this.primary.getBounds();
            if (primaryControlBounds != null && primaryControlBounds.height < 50) {
                position = new Point(primaryControlBounds.x, primaryControlBounds.y + primaryControlBounds.height + 1);
                position = this.primary.getParent().toDisplay(position);
            } else {
                position = new Point(decoratorControlBounds.x + decoratorControlBounds.width + 2, decoratorControlBounds.y + 2);
                position = this.control.getParent().toDisplay(position);
            }
            PropertyEditorAssistDialog dialog = new PropertyEditorAssistDialog(this.shell(), position, this.assistContext);
            dialog.open();
        }
    }

    private void refresh() {
        boolean enabled;
        boolean bl = enabled = this.element == null ? false : this.element.isPropertyEnabled(this.property);
        if (enabled) {
            if (this.property instanceof ValueProperty) {
                Value value = this.element.read((ValueProperty)this.property);
                this.problem = value.validate();
            } else if (this.property instanceof ListProperty) {
                ModelElementList list = this.element.read((ListProperty)this.property);
                this.problem = list.validate();
            } else if (this.property instanceof ElementProperty) {
                ModelElementHandle handle = this.element.read((ElementProperty)this.property);
                this.problem = handle.validate(false);
            } else {
                throw new IllegalStateException(this.property.getClass().getName());
            }
            this.assistContext = new PropertyEditorAssistContext(this.part, this.element, this.property, this.context);
            ArrayList<PropertyEditorAssistContributor> contributors = new ArrayList<PropertyEditorAssistContributor>(SYSTEM_CONTRIBUTORS);
            contributors.add(new ProblemsAssistContributor(this.problem));
            block2: for (String string : this.contributorsToSuppress) {
                Iterator itr = contributors.iterator();
                while (itr.hasNext()) {
                    PropertyEditorAssistContributor contributor = (PropertyEditorAssistContributor)itr.next();
                    if (!contributor.getId().equals(string)) continue;
                    itr.remove();
                    continue block2;
                }
            }
            for (Class clazz : this.additionalContributors) {
                try {
                    contributors.add((PropertyEditorAssistContributor)clazz.newInstance());
                }
                catch (Exception e) {
                    SapphireUiFrameworkPlugin.log(e);
                }
            }
            Collections.sort(contributors, new Comparator<PropertyEditorAssistContributor>(){

                @Override
                public int compare(PropertyEditorAssistContributor c1, PropertyEditorAssistContributor c2) {
                    return c1.getPriority() - c2.getPriority();
                }
            });
            for (PropertyEditorAssistContributor propertyEditorAssistContributor : contributors) {
                propertyEditorAssistContributor.contribute(this.assistContext);
            }
            if (this.assistContext.isEmpty()) {
                this.assistContext = null;
            } else {
                Status.Severity severity = this.problem.severity();
                if (severity != Status.Severity.ERROR && severity != Status.Severity.WARNING && severity != Status.Severity.INFO) {
                    this.problem = null;
                }
            }
        } else {
            this.assistContext = null;
            this.problem = null;
        }
        this.refreshImageAndCursor();
    }

    private void refreshImageAndCursor() {
        if (this.control.isDisposed()) {
            return;
        }
        SapphireImageCache imageCache = this.part.getImageCache();
        if (this.assistContext != null) {
            if (this.problem != null) {
                String fieldDecorationId;
                switch (this.problem.severity()) {
                    case ERROR: {
                        fieldDecorationId = "DEC_ERROR";
                        break;
                    }
                    case WARNING: {
                        fieldDecorationId = "DEC_WARNING";
                        break;
                    }
                    default: {
                        fieldDecorationId = "DEC_INFORMATION";
                    }
                }
                FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration(fieldDecorationId);
                this.control.setImage(fieldDecoration.getImage());
            } else if (this.mouseOverEditorControl) {
                this.control.setImage(imageCache.getImage(IMG_ASSIST));
            } else {
                this.control.setImage(imageCache.getImage(IMG_ASSIST_FAINT));
            }
            this.control.setVisible(true);
            this.control.setCursor(Display.getCurrent().getSystemCursor(21));
        } else {
            this.control.setVisible(false);
            this.control.setImage(imageCache.getImage(IMG_ASSIST_CLEAR));
            this.control.setCursor(null);
        }
    }

    private class EditorControlMouseTrackListener
    extends MouseTrackAdapter {
        private EditorControlMouseTrackListener() {
        }

        public void mouseEnter(MouseEvent event) {
            PropertyEditorAssistDecorator.this.mouseOverEditorControl = true;
        }

        public void mouseHover(MouseEvent event) {
            PropertyEditorAssistDecorator.this.refreshImageAndCursor();
        }

        public void mouseExit(MouseEvent event) {
            PropertyEditorAssistDecorator.this.mouseOverEditorControl = false;
            this.performedDelayedImageRefresh();
        }

        private void performedDelayedImageRefresh() {
            final Runnable op = new Runnable(){

                public void run() {
                    PropertyEditorAssistDecorator.this.refreshImageAndCursor();
                }
            };
            Thread thread = new Thread(){

                public void run() {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {}
                    Display.getDefault().asyncExec(op);
                }
            };
            thread.start();
        }

        /* synthetic */ EditorControlMouseTrackListener(EditorControlMouseTrackListener editorControlMouseTrackListener, EditorControlMouseTrackListener editorControlMouseTrackListener2) {
            this();
        }
    }
}

