/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.renderers.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.EditFailedException;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.NamedValues;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.internal.binding.AbstractBinding;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRendererFactory;
import org.eclipse.sapphire.ui.renderers.swt.ValuePropertyEditorRenderer;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.SwtUtil;
import org.eclipse.sapphire.ui.swt.renderer.TextOverlayPainter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public final class NamedValuesPropertyEditorRenderer
extends ValuePropertyEditorRenderer {
    private Composite rootComposite;
    private boolean updating;
    private String defaultArbitraryValue;
    private Label overallLabelControl;
    private Label auxTextControl;
    private Button arbitraryValueRadioButton;
    private Text arbitraryValueTextField;
    private NamedValueLocal[] namedValues;
    private Button[] namedValuesRadioButtons;
    private List<Button> radioButtonGroup;

    public NamedValuesPropertyEditorRenderer(SapphireRenderingContext context, SapphirePropertyEditor part) {
        super(context, part);
    }

    protected void createContents(Composite parent) {
        SapphirePropertyEditor part = this.getPart();
        ValueProperty property = (ValueProperty)part.getProperty();
        this.rootComposite = new Composite(parent, 0){

            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                NamedValuesPropertyEditorRenderer.this.overallLabelControl.setEnabled(enabled);
                if (NamedValuesPropertyEditorRenderer.this.auxTextControl != null) {
                    NamedValuesPropertyEditorRenderer.this.auxTextControl.setEnabled(enabled);
                }
                NamedValuesPropertyEditorRenderer.this.arbitraryValueRadioButton.setEnabled(enabled);
                NamedValuesPropertyEditorRenderer.this.arbitraryValueTextField.setEnabled(enabled && NamedValuesPropertyEditorRenderer.this.arbitraryValueRadioButton.getSelection());
                Button[] buttonArray = NamedValuesPropertyEditorRenderer.this.namedValuesRadioButtons;
                int n = buttonArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Button b = buttonArray[n2];
                    b.setEnabled(enabled);
                    ++n2;
                }
            }
        };
        this.rootComposite.setLayout((Layout)GridLayoutUtil.glayout(1, 0, 0));
        int baseIndent = part.getMarginLeft();
        this.rootComposite.setLayoutData((Object)GridLayoutUtil.gdvindent(GridLayoutUtil.gdhindent(GridLayoutUtil.gdhspan(GridLayoutUtil.gdhfill(), 2), baseIndent), 5));
        NamedValues namedValuesAnnotation = (NamedValues)property.getAnnotation(NamedValues.class);
        NamedValues.NamedValue[] namedValueAnnotations = namedValuesAnnotation.namedValues();
        this.namedValues = new NamedValueLocal[namedValueAnnotations.length];
        int i = 0;
        int n = namedValueAnnotations.length;
        while (i < n) {
            NamedValues.NamedValue x = namedValueAnnotations[i];
            String namedValueLabel = property.getLocalizationService().text(x.label(), CapitalizationType.FIRST_WORD_ONLY, true);
            this.namedValues[i] = new NamedValueLocal(x.value(), namedValueLabel);
            ++i;
        }
        this.updating = false;
        this.defaultArbitraryValue = namedValuesAnnotation.defaultArbitraryValue();
        this.defaultArbitraryValue = property.encodeKeywords(this.defaultArbitraryValue);
        Composite composite = new Composite(this.rootComposite, 0);
        composite.setLayoutData((Object)GridLayoutUtil.gdhfill());
        composite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glayout(2, 0, 0), 2));
        this.context.adapt((Control)composite);
        PropertyEditorAssistDecorator decorator = new PropertyEditorAssistDecorator(part, this.context, composite);
        decorator.control().setLayoutData((Object)GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 0x1000000));
        decorator.addEditorControl((Control)this.rootComposite);
        decorator.addEditorControl((Control)composite);
        this.overallLabelControl = new Label(composite, 64);
        this.overallLabelControl.setLayoutData((Object)GridLayoutUtil.gd());
        this.overallLabelControl.setText(property.getLabel(true, CapitalizationType.FIRST_WORD_ONLY, true));
        decorator.addEditorControl((Control)this.overallLabelControl);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NamedValuesPropertyEditorRenderer.this.handleRadioButtonSelectedEvent(event);
            }
        };
        Composite radioButtonsComposite = new Composite(this.rootComposite, 0);
        radioButtonsComposite.setLayoutData((Object)GridLayoutUtil.gdhindent(GridLayoutUtil.gdhfill(), 20));
        radioButtonsComposite.setLayout((Layout)GridLayoutUtil.glayout(2, 0, 0, 0, 0));
        decorator.addEditorControl((Control)radioButtonsComposite);
        this.radioButtonGroup = new ArrayList<Button>();
        String arbitraryValueLabel = String.valueOf(property.getLocalizationService().text(namedValuesAnnotation.arbitraryValueLabel(), CapitalizationType.FIRST_WORD_ONLY, true)) + ":";
        this.arbitraryValueRadioButton = this.createRadioButton(radioButtonsComposite, arbitraryValueLabel);
        this.arbitraryValueRadioButton.setLayoutData((Object)GridLayoutUtil.gd());
        this.arbitraryValueRadioButton.addSelectionListener((SelectionListener)selectionListener);
        this.radioButtonGroup.add(this.arbitraryValueRadioButton);
        decorator.addEditorControl((Control)this.arbitraryValueRadioButton);
        this.arbitraryValueTextField = new Text(radioButtonsComposite, 2048);
        this.arbitraryValueTextField.setLayoutData((Object)GridLayoutUtil.gdwhint(GridLayoutUtil.gd(), 150));
        decorator.addEditorControl((Control)this.arbitraryValueTextField);
        this.arbitraryValueTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NamedValuesPropertyEditorRenderer.this.handleArbitraryValueTextFieldChangedEvent(event);
            }
        });
        TextOverlayPainter.Controller textOverlayPainterController = new TextOverlayPainter.Controller(){

            public String getDefaultText() {
                return NamedValuesPropertyEditorRenderer.this.getModelElement().read(NamedValuesPropertyEditorRenderer.this.getProperty()).getDefaultText();
            }
        };
        TextOverlayPainter.install(this.arbitraryValueTextField, textOverlayPainterController);
        this.namedValuesRadioButtons = new Button[this.namedValues.length];
        int i2 = 0;
        while (i2 < this.namedValues.length) {
            Button rb = this.createRadioButton(radioButtonsComposite, this.namedValues[i2].valueName);
            rb.addSelectionListener((SelectionListener)selectionListener);
            decorator.addEditorControl((Control)rb);
            this.namedValuesRadioButtons[i2] = rb;
            this.radioButtonGroup.add(rb);
            ++i2;
        }
        this.rootComposite.setData("peditor", (Object)this);
        this.binding = new NamedValuesBinding(this.getPart(), this.context);
        this.rootComposite.setData("binding", (Object)this.binding);
        this.addControl((Control)this.rootComposite);
        this.context.adapt((Control)this.rootComposite);
    }

    private Button createRadioButton(Composite parent, String label) {
        Button b = new Button(parent, 16);
        b.setLayoutData((Object)GridLayoutUtil.gdhspan(GridLayoutUtil.gd(), 2));
        b.setText(label);
        return b;
    }

    private void handleRadioButtonSelectedEvent(SelectionEvent event) {
        Button b = (Button)event.getSource();
        if (b == this.arbitraryValueRadioButton) {
            this.setPropertyValue2(this.defaultArbitraryValue);
        } else {
            int i = 0;
            while (i < this.namedValuesRadioButtons.length) {
                if (b == this.namedValuesRadioButtons[i]) {
                    this.setPropertyValue2(this.namedValues[i].value);
                    break;
                }
                ++i;
            }
        }
    }

    private void handleArbitraryValueTextFieldChangedEvent(ModifyEvent event) {
        if (this.updating) {
            return;
        }
        this.setPropertyValue2(this.arbitraryValueTextField.getText());
    }

    private void update() {
        if (this.updating) {
            return;
        }
        this.updating = true;
        try {
            Value val = this.getModelElement().read(this.getProperty());
            String valueWithDefault = val.getText(true);
            NamedValueLocal namedValue = null;
            if (valueWithDefault != null) {
                int i = 0;
                while (i < this.namedValues.length) {
                    NamedValueLocal nm = this.namedValues[i];
                    if (valueWithDefault.equals(nm.value)) {
                        namedValue = nm;
                        break;
                    }
                    ++i;
                }
            }
            if (namedValue != null) {
                Button buttonToSelect = null;
                int i = 0;
                while (i < this.namedValues.length) {
                    if (namedValue == this.namedValues[i]) {
                        buttonToSelect = this.namedValuesRadioButtons[i];
                        break;
                    }
                    ++i;
                }
                SwtUtil.changeRadioButtonSelection(this.radioButtonGroup, buttonToSelect);
                this.arbitraryValueTextField.setEnabled(false);
                this.arbitraryValueTextField.setText("");
            } else {
                SwtUtil.changeRadioButtonSelection(this.radioButtonGroup, this.arbitraryValueRadioButton);
                this.arbitraryValueTextField.setEnabled(true);
                String existingValue = this.arbitraryValueTextField.getText();
                String valueWithoutDefault = val.getText(false);
                String string = valueWithoutDefault = valueWithoutDefault == null ? "" : valueWithoutDefault;
                if (!existingValue.equals(valueWithoutDefault)) {
                    this.arbitraryValueTextField.setText(valueWithoutDefault);
                }
            }
        }
        finally {
            this.updating = false;
        }
    }

    private void setPropertyValue2(String value) {
        try {
            this.getModelElement().write(this.getProperty(), (Object)value);
        }
        catch (Exception e) {
            EditFailedException editFailedException = EditFailedException.findAsCause((Throwable)e);
            if (editFailedException != null) {
                this.update();
            }
            SapphireUiFrameworkPlugin.log(e);
        }
    }

    protected void handleFocusReceivedEvent() {
        this.namedValuesRadioButtons[0].setFocus();
    }

    public static final class Factory
    extends PropertyEditorRendererFactory {
        public boolean isApplicableTo(SapphirePropertyEditor propertyEditorDefinition) {
            ModelProperty property = propertyEditorDefinition.getProperty();
            return property instanceof ValueProperty && property.hasAnnotation(NamedValues.class);
        }

        public PropertyEditorRenderer create(SapphireRenderingContext context, SapphirePropertyEditor part) {
            return new NamedValuesPropertyEditorRenderer(context, part);
        }
    }

    private static class NamedValueLocal {
        public String value;
        public final String valueName;

        public NamedValueLocal(String value, String valueName) {
            this.value = value;
            this.valueName = valueName;
        }
    }

    private final class NamedValuesBinding
    extends AbstractBinding {
        public NamedValuesBinding(SapphirePropertyEditor editor, SapphireRenderingContext context) {
            super(editor, context, (Control)NamedValuesPropertyEditorRenderer.this.rootComposite);
        }

        protected void doUpdateModel() {
        }

        protected void doUpdateTarget() {
            NamedValuesPropertyEditorRenderer.this.update();
        }
    }
}

