/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.java.jdt.ui.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.AddUnimplementedConstructorsAction;
import org.eclipse.jdt.ui.actions.FormatAllAction;
import org.eclipse.jdt.ui.actions.OrganizeImportsAction;
import org.eclipse.jdt.ui.actions.OverrideMethodsAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sapphire.DisposeEvent;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeConstraintBehavior;
import org.eclipse.sapphire.java.JavaTypeConstraintService;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.modeling.ReferenceValue;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphirePropertyEditorActionHandler;
import org.eclipse.sapphire.ui.SapphirePropertyEditorCondition;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireActionHandlerDef;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaTypeCreateActionHandler
extends SapphirePropertyEditorActionHandler {
    private final JavaTypeKind kind;

    public JavaTypeCreateActionHandler(JavaTypeKind kind) {
        this.kind = kind;
    }

    public void init(SapphireAction action, ISapphireActionHandlerDef def) {
        super.init(action, def);
        final IModelElement element = this.getModelElement();
        final ValueProperty property = (ValueProperty)this.getProperty();
        final ModelPropertyListener listener = new ModelPropertyListener(){

            public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                JavaTypeCreateActionHandler.this.refreshEnablementState();
            }
        };
        element.addListener(listener, property.getName());
        this.attach(new Listener(){

            public void handle(Event event) {
                if (event instanceof DisposeEvent) {
                    element.removeListener(listener, property.getName());
                }
            }
        });
    }

    protected Object run(SapphireRenderingContext context) {
        ModelProperty property;
        final IModelElement element = this.getModelElement();
        Value javaTypeNameValue = element.read((ValueProperty)(property = this.getProperty()));
        if (javaTypeNameValue.isMalformed()) {
            return null;
        }
        final JavaTypeName javaTypeName = (JavaTypeName)javaTypeNameValue.getContent();
        if (javaTypeName.pkg() == null && !MessageDialog.openConfirm((Shell)context.getShell(), (String)Resources.discourageDialogTitle, (String)Resources.discourageDefaultPackage)) {
            return null;
        }
        if (!Character.isUpperCase(javaTypeName.simple().charAt(0)) && !MessageDialog.openConfirm((Shell)context.getShell(), (String)Resources.discourageDialogTitle, (String)Resources.discourageLowerCase)) {
            return null;
        }
        JavaTypeConstraintService javaTypeConstraintService = (JavaTypeConstraintService)element.service(property, JavaTypeConstraintService.class);
        IProject proj = (IProject)element.adapt(IProject.class);
        IJavaProject jproj = JavaCore.create((IProject)proj);
        JavaTypeName expectedBaseClassTemp = null;
        final ArrayList<JavaTypeName> expectedInterfaces = new ArrayList<JavaTypeName>();
        if (javaTypeConstraintService != null) {
            JavaTypeConstraintBehavior behavior = javaTypeConstraintService.behavior();
            SortedSet types = javaTypeConstraintService.types();
            Iterator iterator = types.iterator();
            int i = 0;
            int n = behavior == JavaTypeConstraintBehavior.ALL ? types.size() : Math.min(1, types.size());
            while (i < n) {
                String typeName = (String)iterator.next();
                try {
                    IType type = jproj.findType(typeName.replace('$', '.'));
                    if (type != null && type.exists()) {
                        if (type.isClass()) {
                            expectedBaseClassTemp = new JavaTypeName(typeName);
                        } else if (type.isInterface()) {
                            expectedInterfaces.add(new JavaTypeName(typeName));
                        }
                    }
                }
                catch (Exception e) {
                    LoggingService.log((Exception)e);
                }
                ++i;
            }
        }
        final JavaTypeName expectedBaseClass = expectedBaseClassTemp;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("", 7);
                JavaTypeKind kind = JavaTypeCreateActionHandler.this.kind;
                StringBuilder buf = new StringBuilder();
                if (javaTypeName.pkg() != null) {
                    buf.append("package ");
                    buf.append(javaTypeName.pkg());
                    buf.append(";\n\n");
                }
                ArrayList<JavaTypeName> imports = new ArrayList<JavaTypeName>();
                imports.add(javaTypeName);
                String base = null;
                if (kind == JavaTypeKind.CLASS && expectedBaseClass != null) {
                    base = JavaTypeCreateActionHandler.deriveSafeLocalName(expectedBaseClass, imports);
                }
                ArrayList<String> interfaces = new ArrayList<String>();
                if (kind == JavaTypeKind.CLASS || kind == JavaTypeKind.INTERFACE) {
                    for (JavaTypeName t : expectedInterfaces) {
                        interfaces.add(JavaTypeCreateActionHandler.deriveSafeLocalName(t, imports));
                    }
                }
                imports.remove(javaTypeName);
                if (!imports.isEmpty()) {
                    for (JavaTypeName t : imports) {
                        buf.append("import ");
                        buf.append(t.qualified().replace('$', '.'));
                        buf.append(";\n");
                    }
                    buf.append('\n');
                }
                buf.append("public ");
                switch (kind) {
                    case ANNOTATION: {
                        buf.append("@interface");
                        break;
                    }
                    case ENUM: {
                        buf.append("enum");
                        break;
                    }
                    case INTERFACE: {
                        buf.append("interface");
                        break;
                    }
                    default: {
                        buf.append("class");
                    }
                }
                buf.append(' ');
                buf.append(javaTypeName.simple());
                if (base != null) {
                    buf.append(" extends ");
                    buf.append(base);
                }
                if (!interfaces.isEmpty()) {
                    buf.append(kind == JavaTypeKind.INTERFACE ? " extends " : " implements ");
                    boolean first = true;
                    for (String implementsType : interfaces) {
                        if (first) {
                            first = false;
                        } else {
                            buf.append(", ");
                        }
                        buf.append(implementsType);
                    }
                }
                buf.append("\n{\n}\n");
                monitor.worked(1);
                IProject proj = (IProject)element.adapt(IProject.class);
                IJavaProject jproj = JavaCore.create((IProject)proj);
                try {
                    IPackageFragmentRoot src = JavaTypeCreateActionHandler.this.src(jproj);
                    IPackageFragment pkg = src.createPackageFragment(javaTypeName.pkg() == null ? "" : javaTypeName.pkg(), true, null);
                    ICompilationUnit cu = pkg.createCompilationUnit(String.valueOf(javaTypeName.simple()) + ".java", buf.toString(), true, null);
                    cu.save(null, true);
                    monitor.worked(1);
                    IEditorPart editor = JavaUI.openInEditor((IJavaElement)cu);
                    IWorkbenchPartSite site = editor.getSite();
                    monitor.worked(1);
                    if (kind == JavaTypeKind.CLASS) {
                        IType type = cu.getType(javaTypeName.simple());
                        ASTParser parser = ASTParser.newParser((int)3);
                        parser.setResolveBindings(true);
                        parser.setSource(cu);
                        CompilationUnit ast = (CompilationUnit)parser.createAST(null);
                        ASTNode node = NodeFinder.perform((ASTNode)ast, (ISourceRange)type.getNameRange());
                        while (!(node instanceof AbstractTypeDeclaration)) {
                            node = node.getParent();
                        }
                        ITypeBinding typeBinding = ((AbstractTypeDeclaration)node).resolveBinding();
                        IWorkspaceRunnable addUnimplementedConstructorsOp = AddUnimplementedConstructorsAction.createRunnable((CompilationUnit)ast, (ITypeBinding)typeBinding, null, (int)-1, (boolean)false, (int)1, (boolean)false);
                        addUnimplementedConstructorsOp.run(null);
                        IWorkspaceRunnable overrideMethodsOp = OverrideMethodsAction.createRunnable((CompilationUnit)ast, (ITypeBinding)typeBinding, null, (int)-1, (boolean)false);
                        overrideMethodsOp.run(null);
                    }
                    monitor.worked(1);
                    OrganizeImportsAction organizeImportsAction = new OrganizeImportsAction((IWorkbenchSite)site);
                    organizeImportsAction.run(cu);
                    monitor.worked(1);
                    FormatAllAction formatAllAction = new FormatAllAction((IWorkbenchSite)site);
                    formatAllAction.runOnMultiple(new ICompilationUnit[]{cu});
                    monitor.worked(1);
                    editor.doSave(null);
                    monitor.worked(1);
                }
                catch (CoreException e) {
                    LoggingService.log((Exception)((Object)e));
                }
                monitor.done();
            }
        };
        try {
            new ProgressMonitorDialog(context.getShell()).run(false, false, op);
        }
        catch (InvocationTargetException e) {
            LoggingService.log((Exception)e);
        }
        catch (InterruptedException e) {
            LoggingService.log((Exception)e);
        }
        return null;
    }

    protected boolean computeEnablementState() {
        boolean enabled = super.computeEnablementState();
        if (enabled) {
            String typeName;
            ReferenceValue ref = (ReferenceValue)this.getModelElement().read(this.getProperty());
            enabled = false;
            if (!ref.isMalformed() && (typeName = ref.getText()) != null && typeName.indexOf(36) == -1 && ref.resolve() == null) {
                enabled = true;
            }
        }
        return enabled;
    }

    private final IPackageFragmentRoot src(IJavaProject project) throws JavaModelException {
        IPackageFragmentRoot[] iPackageFragmentRootArray = project.getPackageFragmentRoots();
        int n = iPackageFragmentRootArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            if (root.getKind() == 1) {
                return root;
            }
            ++n2;
        }
        return null;
    }

    private static String deriveSafeLocalName(JavaTypeName type, Collection<JavaTypeName> imports) {
        boolean collision = false;
        for (JavaTypeName n : imports) {
            if (!n.simple().equals(type.simple())) continue;
            collision = true;
            break;
        }
        if (collision) {
            return type.qualified().replace('$', '.');
        }
        imports.add(type);
        return type.simple();
    }

    protected static abstract class Condition
    extends SapphirePropertyEditorCondition {
        protected Condition() {
        }

        protected final boolean evaluate(SapphirePropertyEditor part) {
            Reference referenceAnnotation;
            ModelProperty property = part.getProperty();
            IModelElement element = part.getModelElement();
            if (property instanceof ValueProperty && element != null && property.isOfType(JavaTypeName.class) && (referenceAnnotation = (Reference)property.getAnnotation(Reference.class)) != null && referenceAnnotation.target() == JavaType.class) {
                return this.evaluate((JavaTypeConstraintService)element.service(property, JavaTypeConstraintService.class));
            }
            return false;
        }

        protected abstract boolean evaluate(JavaTypeConstraintService var1);
    }

    private static final class Resources
    extends NLS {
        public static String discourageDialogTitle;
        public static String discourageDefaultPackage;
        public static String discourageLowerCase;

        static {
            Resources.initializeMessages((String)JavaTypeCreateActionHandler.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

