/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.architecture.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.samples.architecture.IArchitecture;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.sapphire.ui.SapphireEditorPagePart;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsEditorPage;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.swt.graphiti.editor.SapphireDiagramEditor;
import org.eclipse.sapphire.ui.swt.graphiti.editor.SapphireDiagramEditorFactory;
import org.eclipse.sapphire.ui.swt.graphiti.editor.SapphireDiagramEditorInput;
import org.eclipse.sapphire.ui.swt.xml.editor.XmlEditorResourceStore;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public final class ArchitectureEditor
extends SapphireEditor {
    private IArchitecture model;
    private StructuredTextEditor pageSource;
    private SapphireDiagramEditor pageDiagram;
    private MasterDetailsEditorPage pageDetails;

    public ArchitectureEditor() {
        super("org.eclipse.sapphire.samples");
    }

    protected void createSourcePages() throws PartInitException {
        this.pageSource = new StructuredTextEditor();
        this.pageSource.setEditorPart((IEditorPart)this);
        FileEditorInput rootEditorInput = (FileEditorInput)this.getEditorInput();
        int index = this.addPage((IEditorPart)this.pageSource, (IEditorInput)rootEditorInput);
        this.setPageText(index, "Source");
    }

    protected IModelElement createModel() {
        this.model = (IArchitecture)IArchitecture.TYPE.instantiate((Resource)new RootXmlResource((XmlResourceStore)new XmlEditorResourceStore((SapphireEditor)this, this.pageSource)));
        return this.model;
    }

    protected void createDiagramPages() throws PartInitException {
        Path path = new Path("org.eclipse.sapphire.samples/org/eclipse/sapphire/samples/architecture/ArchitectureEditor.sdef/DiagramPage");
        this.pageDiagram = new SapphireDiagramEditor((IModelElement)this.model, (IPath)path);
        SapphireDiagramEditorInput diagramEditorInput = null;
        try {
            diagramEditorInput = SapphireDiagramEditorFactory.createEditorInput((IFile)((IFile)this.model.adapt(IFile.class)));
        }
        catch (Exception e) {
            SapphireUiFrameworkPlugin.log((Throwable)e);
        }
        if (diagramEditorInput != null) {
            this.addPage(0, (IEditorPart)this.pageDiagram, (IEditorInput)diagramEditorInput);
            this.setPageText(0, "Diagram");
            this.setPageId(this.pages.get(0), "Diagram", (SapphireEditorPagePart)this.pageDiagram.getPart());
        }
    }

    protected void createFormPages() throws PartInitException {
        Path path = new Path("org.eclipse.sapphire.samples/org/eclipse/sapphire/samples/architecture/ArchitectureEditor.sdef/DetailsPage");
        this.pageDetails = new MasterDetailsEditorPage((SapphireEditor)this, (IModelElement)this.model, (IPath)path);
        this.addPage(1, (IFormPage)this.pageDetails);
        this.setPageText(1, "Details");
        this.setPageId(this.pages.get(1), "Details", (SapphireEditorPagePart)this.pageDetails.getPart());
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        this.pageDiagram.doSave(monitor);
    }
}

