/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.contacts.internal;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.samples.contacts.IAssistant;
import org.eclipse.sapphire.samples.contacts.IAssistantTask;
import org.eclipse.sapphire.services.ValueNormalizationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Assistant
extends ModelElement
implements IAssistant {
    private ModelElementList<IAssistantTask> delegatedTasks;
    private Value<String> name;
    private Value<String> notes;

    public Assistant(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public Assistant(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IAssistantTask> getDelegatedTasks() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.delegatedTasks == null) {
                this.refresh((ModelProperty)PROP_DELEGATED_TASKS, true);
            }
            return this.delegatedTasks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getName() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.name == null) {
                this.refresh((ModelProperty)PROP_NAME, true);
            }
            return this.name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setName(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_NAME.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_NAME, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_NAME, true);
            if (!Assistant.equal((String)this.name.getText(false), (String)value)) {
                this.resource().binding(PROP_NAME).write(value);
                this.refresh((ModelProperty)PROP_NAME, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getNotes() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.notes == null) {
                this.refresh((ModelProperty)PROP_NOTES, true);
            }
            return this.notes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNotes(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_NOTES.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_NOTES, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_NOTES, true);
            if (!Assistant.equal((String)this.notes.getText(false), (String)value)) {
                this.resource().binding(PROP_NOTES).write(value);
                this.refresh((ModelProperty)PROP_NOTES, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_DELEGATED_TASKS) {
                if (this.delegatedTasks == null) {
                    if (force) {
                        this.delegatedTasks = new ModelElementList((IModelElement)this, PROP_DELEGATED_TASKS);
                        ListBindingImpl binding = this.resource().binding(PROP_DELEGATED_TASKS);
                        this.delegatedTasks.init(binding);
                        this.refreshPropertyEnablement((ModelProperty)PROP_DELEGATED_TASKS);
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_DELEGATED_TASKS);
                    boolean notified = this.delegatedTasks.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_DELEGATED_TASKS, enablementRefreshResult);
                    }
                }
            } else if (property == PROP_NAME) {
                if (this.name != null || force) {
                    Value<String> oldValue = this.name;
                    String val = this.resource().binding(PROP_NAME).read();
                    this.name = new Value((IModelElement)this, PROP_NAME, ((ValueNormalizationService)this.service((ModelProperty)PROP_NAME, ValueNormalizationService.class)).normalize(PROP_NAME.encodeKeywords(val)));
                    this.name.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_NAME);
                    if (oldValue != null) {
                        if (this.name.equals(oldValue)) {
                            this.name = oldValue;
                        }
                        if (this.name != oldValue || enablementRefreshResult.changed()) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_NAME, enablementRefreshResult);
                        }
                    }
                }
            } else if (property == PROP_NOTES && (this.notes != null || force)) {
                Value<String> oldValue = this.notes;
                String val = this.resource().binding(PROP_NOTES).read();
                this.notes = new Value((IModelElement)this, PROP_NOTES, ((ValueNormalizationService)this.service((ModelProperty)PROP_NOTES, ValueNormalizationService.class)).normalize(PROP_NOTES.encodeKeywords(val)));
                this.notes.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_NOTES);
                if (oldValue != null) {
                    if (this.notes.equals(oldValue)) {
                        this.notes = oldValue;
                    }
                    if (this.notes != oldValue || enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_NOTES, enablementRefreshResult);
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_DELEGATED_TASKS) {
            return this.getDelegatedTasks();
        }
        if (property == PROP_NAME) {
            return this.getName();
        }
        if (property == PROP_NOTES) {
            return this.getNotes();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_NAME) {
            this.setName((String)value);
            return;
        }
        if (property == PROP_NOTES) {
            this.setNotes((String)value);
            return;
        }
        super.write(property, value);
    }
}

