/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.gallery.internal;

import java.math.BigInteger;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.samples.gallery.IBigIntegerValueGallery;
import org.eclipse.sapphire.services.ValueNormalizationService;
import org.eclipse.sapphire.services.ValueSerializationMasterService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BigIntegerValueGallery
extends ModelElement
implements IBigIntegerValueGallery {
    private Value<BigInteger> positive;
    private Value<BigInteger> rangeConstrainedWithDefault;
    private Value<BigInteger> simple;

    public BigIntegerValueGallery(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public BigIntegerValueGallery(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<BigInteger> getPositive() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.positive == null) {
                this.refresh((ModelProperty)PROP_POSITIVE, true);
            }
            return this.positive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPositive(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_POSITIVE.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_POSITIVE, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_POSITIVE, true);
            if (!BigIntegerValueGallery.equal((String)this.positive.getText(false), (String)value)) {
                this.resource().binding(PROP_POSITIVE).write(value);
                this.refresh((ModelProperty)PROP_POSITIVE, false);
            }
        }
    }

    @Override
    public void setPositive(BigInteger value) {
        this.setPositive(value != null ? ((ValueSerializationMasterService)this.service((ModelProperty)PROP_POSITIVE, ValueSerializationMasterService.class)).encode((Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<BigInteger> getRangeConstrainedWithDefault() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.rangeConstrainedWithDefault == null) {
                this.refresh((ModelProperty)PROP_RANGE_CONSTRAINED_WITH_DEFAULT, true);
            }
            return this.rangeConstrainedWithDefault;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRangeConstrainedWithDefault(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_RANGE_CONSTRAINED_WITH_DEFAULT.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_RANGE_CONSTRAINED_WITH_DEFAULT, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_RANGE_CONSTRAINED_WITH_DEFAULT, true);
            if (!BigIntegerValueGallery.equal((String)this.rangeConstrainedWithDefault.getText(false), (String)value)) {
                this.resource().binding(PROP_RANGE_CONSTRAINED_WITH_DEFAULT).write(value);
                this.refresh((ModelProperty)PROP_RANGE_CONSTRAINED_WITH_DEFAULT, false);
            }
        }
    }

    @Override
    public void setRangeConstrainedWithDefault(BigInteger value) {
        this.setRangeConstrainedWithDefault(value != null ? ((ValueSerializationMasterService)this.service((ModelProperty)PROP_RANGE_CONSTRAINED_WITH_DEFAULT, ValueSerializationMasterService.class)).encode((Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<BigInteger> getSimple() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.simple == null) {
                this.refresh((ModelProperty)PROP_SIMPLE, true);
            }
            return this.simple;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSimple(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_SIMPLE.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_SIMPLE, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_SIMPLE, true);
            if (!BigIntegerValueGallery.equal((String)this.simple.getText(false), (String)value)) {
                this.resource().binding(PROP_SIMPLE).write(value);
                this.refresh((ModelProperty)PROP_SIMPLE, false);
            }
        }
    }

    @Override
    public void setSimple(BigInteger value) {
        this.setSimple(value != null ? ((ValueSerializationMasterService)this.service((ModelProperty)PROP_SIMPLE, ValueSerializationMasterService.class)).encode((Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_POSITIVE) {
                if (this.positive != null || force) {
                    Value<BigInteger> oldValue = this.positive;
                    String val = this.resource().binding(PROP_POSITIVE).read();
                    this.positive = new Value((IModelElement)this, PROP_POSITIVE, ((ValueNormalizationService)this.service((ModelProperty)PROP_POSITIVE, ValueNormalizationService.class)).normalize(PROP_POSITIVE.encodeKeywords(val)));
                    this.positive.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_POSITIVE);
                    if (oldValue != null) {
                        if (this.positive.equals(oldValue)) {
                            this.positive = oldValue;
                        }
                        if (this.positive != oldValue || enablementRefreshResult.changed()) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_POSITIVE, enablementRefreshResult);
                        }
                    }
                }
            } else if (property == PROP_RANGE_CONSTRAINED_WITH_DEFAULT) {
                if (this.rangeConstrainedWithDefault != null || force) {
                    Value<BigInteger> oldValue = this.rangeConstrainedWithDefault;
                    String val = this.resource().binding(PROP_RANGE_CONSTRAINED_WITH_DEFAULT).read();
                    this.rangeConstrainedWithDefault = new Value((IModelElement)this, PROP_RANGE_CONSTRAINED_WITH_DEFAULT, ((ValueNormalizationService)this.service((ModelProperty)PROP_RANGE_CONSTRAINED_WITH_DEFAULT, ValueNormalizationService.class)).normalize(PROP_RANGE_CONSTRAINED_WITH_DEFAULT.encodeKeywords(val)));
                    this.rangeConstrainedWithDefault.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_RANGE_CONSTRAINED_WITH_DEFAULT);
                    if (oldValue != null) {
                        if (this.rangeConstrainedWithDefault.equals(oldValue)) {
                            this.rangeConstrainedWithDefault = oldValue;
                        }
                        if (this.rangeConstrainedWithDefault != oldValue || enablementRefreshResult.changed()) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_RANGE_CONSTRAINED_WITH_DEFAULT, enablementRefreshResult);
                        }
                    }
                }
            } else if (property == PROP_SIMPLE && (this.simple != null || force)) {
                Value<BigInteger> oldValue = this.simple;
                String val = this.resource().binding(PROP_SIMPLE).read();
                this.simple = new Value((IModelElement)this, PROP_SIMPLE, ((ValueNormalizationService)this.service((ModelProperty)PROP_SIMPLE, ValueNormalizationService.class)).normalize(PROP_SIMPLE.encodeKeywords(val)));
                this.simple.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_SIMPLE);
                if (oldValue != null) {
                    if (this.simple.equals(oldValue)) {
                        this.simple = oldValue;
                    }
                    if (this.simple != oldValue || enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_SIMPLE, enablementRefreshResult);
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_POSITIVE) {
            return this.getPositive();
        }
        if (property == PROP_RANGE_CONSTRAINED_WITH_DEFAULT) {
            return this.getRangeConstrainedWithDefault();
        }
        if (property == PROP_SIMPLE) {
            return this.getSimple();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_POSITIVE) {
            if (!(value instanceof String)) {
                this.setPositive((BigInteger)value);
            } else {
                this.setPositive((String)value);
            }
            return;
        }
        if (property == PROP_RANGE_CONSTRAINED_WITH_DEFAULT) {
            if (!(value instanceof String)) {
                this.setRangeConstrainedWithDefault((BigInteger)value);
            } else {
                this.setRangeConstrainedWithDefault((String)value);
            }
            return;
        }
        if (property == PROP_SIMPLE) {
            if (!(value instanceof String)) {
                this.setSimple((BigInteger)value);
            } else {
                this.setSimple((String)value);
            }
            return;
        }
        super.write(property, value);
    }
}

